package ipsk.webapps.db.speech.project.form;

import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.List;

import javax.persistence.EntityManager;
import javax.servlet.http.HttpServletRequest;

import ips.beans.ExtBeanInfo;
import ips.beans.PersistenceIntrospector;
import ipsk.db.speech.Account;
import ipsk.db.speech.FormConfiguration;
import ipsk.db.speech.Project;
import ipsk.db.speech.PropertyConfiguration;
import ipsk.db.speech.Speaker;
import ipsk.db.speech.UserRoleId;
import ipsk.jsp.fmt.LocaleSupport;
import ipsk.persistence.PersistenceObjectIdentifier;
import ipsk.webapps.BasicPersistenceBeanController;
import ipsk.webapps.ControllerException;
import ipsk.webapps.db.speech.BasicWikiSpeechController;
import ipsk.webapps.db.speech.WikiSpeechSecurityManager;

public class PropertyConfigurationController extends BasicWikiSpeechController<PropertyConfiguration> {
	
	
	public static class PropertyView{
		private String name;
		private String resourceKey;
		private String resourceBundleName;
		public String getResourceBundleName() {
			return resourceBundleName;
		}

		public String getResourceKey() {
			return resourceKey;
		}

		public String getName() {
			return name;
		}
		
		public PropertyView(String name,String resourceBundleName, String resourceKey) {
			super();
			this.name = name;
			this.resourceKey = resourceKey;
			this.resourceBundleName=resourceBundleName;
		}	
	}
	
	private String enclosingClassId;
	private ExtBeanInfo enclosingClassBeanInfo;
	private String enclosingClassResourceBundleName;
	
	public String getEnclosingClassId() {
		return enclosingClassId;
	}
	public void setEnclosingClassId(String enclosingClassId) {
		this.enclosingClassId = enclosingClassId;
	
		Class<?> enclosingClass;
		
		String enclosingJavaClassName=getEnclosingJavaClassName();
		try {
			enclosingClass = Class.forName(enclosingJavaClassName);
			enclosingClassBeanInfo = PersistenceIntrospector.getExtendedBeanInfo(enclosingClass);
			enclosingClassResourceBundleName=enclosingClassBeanInfo.getResourceBundleName();
		} catch (ClassNotFoundException e) {		
			e.printStackTrace();
		} catch (IntrospectionException e) {
			e.printStackTrace();
		}
	}
	public PropertyConfigurationController() {
		super("WebSpeechDBPU",PropertyConfiguration.class, "property_configuration");
		securityManager=new WikiSpeechSecurityManager(this);
	}
	
	protected FormConfiguration owningForm=null;
	
	public FormConfiguration getOwningForm() {
		return owningForm;
	}
	
	protected void applyOwningForm(HttpServletRequest req) {
		String trgClParam=req.getParameter(PersistenceObjectIdentifier.KEY_TARGET_CLASS);
		String idStr=req.getParameter(PersistenceObjectIdentifier.KEY_ID);
		if(FormConfiguration.class.getName().equals(trgClParam) && idStr!=null) {
			int id=Integer.valueOf(idStr);
			EntityManager em=getThreadEntityManager();
			owningForm=em.find(FormConfiguration.class,id);
		}
	}
	
	protected void applyOwningFormForProjectAdmin(HttpServletRequest req) {
				Account acc = getAccountByRequest(req);
				if (acc != null && req.isUserInRole(UserRoleId.RoleName.PROJECT_ADMIN.name())) {
					applyOwningForm(req);
				}
	}
	
	public void processRequest(HttpServletRequest req) throws ControllerException {
		applyOwningFormForProjectAdmin(req);
		super.processRequest(req);
	}
	
	
	private String getEnclosingJavaClassName(){
		return enclosingClassId.replaceFirst("^java:","").trim();
	}
	public PropertyDescriptor[] getEnclosingClassPropertyDescriptors(){
		Class<?> enclosingClass;
		ExtBeanInfo extBeanInfo;
		String enclosingJavaClassName=getEnclosingJavaClassName();
		try {
			enclosingClass = Class.forName(enclosingJavaClassName);
			extBeanInfo = PersistenceIntrospector.getExtendedBeanInfo(enclosingClass);
			PropertyDescriptor[] pds=extBeanInfo.getPersistencePropertyDescriptors();
			return pds;
		} catch (ClassNotFoundException e) {		
			e.printStackTrace();
		} catch (IntrospectionException e) {
			e.printStackTrace();
		}
		return null;
	}
	
	public String getEnclosingClassResourceBundleName(){
		return enclosingClassResourceBundleName;
	}
	public List<PropertyView> getEnclosingClassPropertyViews(){

		PropertyDescriptor[] pds=enclosingClassBeanInfo.getPersistencePropertyDescriptors();
		
		List<PropertyView> propViews=new ArrayList<PropertyView>();
		for(PropertyDescriptor pd:pds){

			String resourceKey=enclosingClassBeanInfo.getPropertyResourceKey(pd.getName());
			PropertyView pv=new PropertyView(pd.getName(),enclosingClassResourceBundleName,resourceKey);
			propViews.add(pv);
		}
		return propViews;

	}
	
	public List<PropertyView> getAnonymityPreservingSpeakerPropertyViews(){
		List<PropertyView> propViews=new ArrayList<PropertyView>();
		for(String pNm:Speaker.ANONYMITY_PRESERVING_SPEAKER_PROPERTY_NAMES){

			String resourceKey=enclosingClassBeanInfo.getPropertyResourceKey(pNm);
			PropertyView pv=new PropertyView(pNm,enclosingClassResourceBundleName,resourceKey);
			propViews.add(pv);
		}
		return propViews;
	}
	
	public String propNameResourceKey(PropertyConfiguration rowPc,String propNm) {
		setEnclosingClassId(rowPc.getPropertyClassId());
		return enclosingClassBeanInfo.getPropertyResourceKey(propNm);
	}

	
	
}
