package ipsk.webapps.db.speech.ws;

import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import java.util.UUID;

import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Root;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Response.Status;

import ipsk.db.speech.Account;
import ipsk.db.speech.Project;
import ipsk.db.speech.Session;
import ipsk.db.speech.SessionDTO;
import ipsk.db.speech.Speaker;
import ipsk.db.speech.UserRoleId;
import ipsk.db.speech.script.Script;
import ipsk.persistence.EntityManagerProvider;
import ipsk.webapps.EntityManagerFactoryInitializer;
import ipsk.webapps.db.speech.AccountController;
import ipsk.webapps.db.speech.WikiSpeechSecurityManager;

@Path("/csrftest")
public class CSRFTestResource extends WikispeechBasicResource<Session>{

	private WikispeechBasicResource<Speaker> relSpeakerRes=new WikispeechBasicResource<Speaker>(Speaker.class);
	
	public CSRFTestResource() {
		super(Session.class);
	}


	
	@GET
	@Produces({MediaType.APPLICATION_JSON,MediaType.APPLICATION_XML})
	@Path("/{sessionId}")
	public Response getSession(@Context HttpServletRequest req,@PathParam("sessionId") String sessionIdStr){
		EntityManager em=EntityManagerFactoryInitializer.getEntityManagerFactory().createEntityManager();
		try{	
			int sessionId=Integer.parseInt(sessionIdStr);
			Session s=em.find(Session.class, sessionId);
			WikiSpeechSecurityManager securityManager = new WikiSpeechSecurityManager(new EntityManagerProvider() {
				@Override
				public EntityManager getThreadEntityManager() {
					return em;
				}
			});
			if(!securityManager.getReadPermission(req, s)){
				return Response.status(Status.FORBIDDEN).build();
			}
			return Response.ok(s).build();
		}finally{
			em.close();
		}
	}
	
	@POST
	@Produces(MediaType.TEXT_PLAIN)
	@Path("/{sessionUUID}")
	public Response storeSession(@Context HttpServletRequest req,@Context ServletContext ctx,@PathParam("sessionUUID") String sessionUUIDStr){
		EntityManager em=EntityManagerFactoryInitializer.getEntityManagerFactory().createEntityManager();
//		WikiSpeechSecurityManager securityManager = new WikiSpeechSecurityManager(new EntityManagerProvider() {
//			@Override
//			public EntityManager getThreadEntityManager() {
//				return em;
//			}
//		});

		Enumeration<String> hNms=req.getHeaderNames();
		
		while(hNms.hasMoreElements()) {
			String hNm=hNms.nextElement();
			ctx.log("Header: "+hNm+": "+req.getHeader(hNm));
		}
			

		
//		UUID sessionUUID=null;
		
//		try{
//		// try to get from path
//		if(sessionUUIDStr!=null){
//			sessionUUID=UUID.fromString(sessionUUIDStr);
//			
//		}
		String res="Created session "+sessionUUIDStr;
		ctx.log("REST Test CSRF: "+res);
		em.close();
		return Response.ok(res).build();
//		}catch(IllegalArgumentException iae){
//			// UUID string could not be parsed
//			return Response.status(Status.BAD_REQUEST).build();
//		}finally {
			
//		}		
		
	}
	
	
	@GET
	@Produces({MediaType.APPLICATION_JSON,MediaType.APPLICATION_XML})
	public Response allSessions(@Context HttpServletRequest req){
		if(req.isUserInRole(UserRoleId.RoleName.ADMIN.name())){
			EntityManager em=EntityManagerFactoryInitializer.getEntityManagerFactory().createEntityManager();
			try{	
				CriteriaBuilder cb = em.getCriteriaBuilder();
				CriteriaQuery<Session> cq = cb.createQuery(Session.class);
				Root<Session> rt = cq.from(Session.class);
				cq.select(rt);
				TypedQuery<Session> q = em.createQuery(cq);
				List<Session> allSesss = q.getResultList();
				final GenericEntity<List<Session>> listEntity = new GenericEntity<List<Session>>(allSesss) {};
				return Response.ok(listEntity).header("X-Total-Count", allSesss.size()).build();

			}finally{
				em.close();
			}
		}else {
			return Response.status(Status.FORBIDDEN).build();
		}
	}
	
	
	/**
	 * Recording  file sub resource upload
	 * @param sc
	 * @param sec
	 * @param sessionIdStr
	 * @return
	 */
	@Path("/{sessionIdOrUUID}/recfile")
	public SessionRecfileResource postRecfile(@PathParam("sessionIdOrUUID") String sessionIdStr) {

		SessionRecfileResource refFileRs = new SessionRecfileResource(sessionIdStr);
		return refFileRs;

	}
	
}
