package ipsk.webapps.db.speech.ws;



import org.glassfish.jersey.server.monitoring.ApplicationEvent;
import org.glassfish.jersey.server.monitoring.ApplicationEventListener;
import org.glassfish.jersey.server.monitoring.RequestEvent;
import org.glassfish.jersey.server.monitoring.RequestEventListener;

public class ExceptionListener implements ApplicationEventListener {

    @Override
    public void onEvent(ApplicationEvent event) {

    }

    @Override
    public RequestEventListener onRequest(RequestEvent requestEvent) {
        return new ExceptionRequestEventListener();
    }

    public static class ExceptionRequestEventListener implements RequestEventListener{
       

        public ExceptionRequestEventListener(){
            super();
        }

        @Override
        public void onEvent(RequestEvent event) {
            switch (event.getType()){
                case ON_EXCEPTION:
                    Throwable t = event.getException();
                    System.err.println("JAX-RS exception event: "+ t);
                    Throwable pt=t;
                    Throwable cause;
                    while((cause=pt.getCause())!=null){
                    	System.err.println(cause);
                    	pt=cause;
                    }
                   
                 default:
            }
        }

    }
}