package ipsk.webapps.db.speech.ws;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Root;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Response.Status;

import ipsk.db.speech.Account;
import ipsk.db.speech.Project;
import ipsk.db.speech.UserRoleId;
import ipsk.persistence.EntityManagerProvider;
import ipsk.webapps.EntityManagerFactoryInitializer;
import ipsk.webapps.PermissionDeniedException;
import ipsk.webapps.db.speech.AccountController;
import ipsk.webapps.db.speech.WikiSpeechSecurityManager;

@Path("/project")
public class ProjectResource {

	@GET
	@Produces({ MediaType.APPLICATION_JSON, MediaType.APPLICATION_XML })
	@Path("/{name}")
	public Response getProject(@Context HttpServletRequest req, @PathParam("name") String name) {
		final EntityManager em = EntityManagerFactoryInitializer.getEntityManagerFactory().createEntityManager();
		WikiSpeechSecurityManager securityManager = new WikiSpeechSecurityManager(new EntityManagerProvider() {
			@Override
			public EntityManager getThreadEntityManager() {
				return em;
			}
		});
		try {
			Project p = em.find(Project.class, name);
			securityManager.checkReadPermission(req, p);
			return Response.ok(p).build();
		} catch (PermissionDeniedException e) {
			return Response.status(Status.FORBIDDEN).build();
		} finally {
			em.close();
		}
	}

	@GET
	@Produces({ MediaType.APPLICATION_JSON, MediaType.APPLICATION_XML })
	public Response getProjects(@Context HttpServletRequest req) {
		final EntityManager em = EntityManagerFactoryInitializer.getEntityManagerFactory().createEntityManager();
		WikiSpeechSecurityManager securityManager = new WikiSpeechSecurityManager(new EntityManagerProvider() {
			@Override
			public EntityManager getThreadEntityManager() {
				return em;
			}
		});
		//String remoteUser=req.getRemoteUser();
		
		try {
			List<Project> allPrjs;
			
			// if user is not ADMIN, limit list of projects to the ones to which the user is assigned as member or administrator
			// ADMIN role user gets all projects
			if(req.isUserInRole(UserRoleId.RoleName.ADMIN.name())){
				CriteriaBuilder cb = em.getCriteriaBuilder();
				CriteriaQuery<Project> cq = cb.createQuery(Project.class);
				Root<Project> rt = cq.from(Project.class);
				cq.select(rt);
				TypedQuery<Project> q = em.createQuery(cq);
				allPrjs = q.getResultList();
			}else{
				Account acc= AccountController.getAccountByRequest(req, em);
				if(acc==null){
					return Response.status(Status.FORBIDDEN).build();
				}
				
				// Does not work as expected
				// Empty when account is only member of accounts
//				Expression<Collection<Account>> admAccs = rt.get("adminAccounts");
//				Expression<Collection<Account>> accs = rt.get("accounts");
//				Predicate isAdm=cb.isMember(acc,admAccs);
//				Predicate isMmb=cb.isMember(acc,accs);
//				Predicate isAssigned=cb.or(isMmb,isAdm);
//				
//				cq.where(isAssigned);
//				System.out.println(cq);
				
				Set<Project> projsSet=new HashSet<Project>();
				projsSet.addAll(acc.getProjects());
				projsSet.addAll(acc.getAdminOfProjects());
				allPrjs=new ArrayList<>(projsSet);
			}
			
			
			for (Project p : allPrjs) {
				securityManager.checkReadPermission(req, p);
			}
			final GenericEntity<List<Project>> listEntity= new GenericEntity<List<Project>>(allPrjs){};
			return Response.ok(listEntity).build();
		} catch (PermissionDeniedException e) {
			return Response.status(Status.FORBIDDEN).build();
		} finally {
			em.close();
		}
	}
	
	@Path("/{name}/script")
	public ProjectScriptResource scriptResource(@PathParam("name") String projectName) {

		return new ProjectScriptResource(projectName);

	}
	
	@Path("/{name}/session")
	public ProjectSessionResource sessionResource(@PathParam("name") String projectName) {

		return new ProjectSessionResource(projectName);

	}
	
	@Path("/{name}/speaker")
	public ProjectSpeakerResource speakerResource(@PathParam("name") String projectName) {

		return new ProjectSpeakerResource(projectName);

	}
	
	@Path("/{name}/resources")
	public ProjectResourcesResource resourcesResource(@PathParam("name") String projectName) {

		return new ProjectResourcesResource(projectName);

	}
	

}
