<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"  %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt" %>
<%@ taglib uri="/ips" prefix="ips" %>
<%@ taglib uri="/wsp" prefix="wsp" %>
<%@ page  isELIgnored="false" contentType="text/html; charset=UTF-8" session="true" errorPage="/errorPage.jsp" %>
<fmt:setBundle basename="Messages" scope="request"/>
<fmt:setBundle var="beans" basename="ipsk.db.speech.PropertyNames" scope="request" />
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
<%@ include file="/stylesheets.jsp" %>
<title><wsp:appTitle/> - <fmt:message key="organisation.delete"/></title>
</head>

<body>
 <table class="page">
 <tr><td colspan="2"><%@ include file="/logoTd.jsp" %></td></tr>
 <tr><td class="contentw" colspan="2"><%@ include file="/titletoolbar.jsp" %></td></tr>
 <tr><td class="menu"><%@ include file="/menu.jsp" %></td>
 <td class="content">
 <h2><fmt:message key="organisation.delete"/></h2>		 
 
<jsp:useBean id="organisationDeletePrjCtrl" scope="request" class="ipsk.webapps.db.speech.OrganisationController" />
<ips:ctrl_process controller="${organisationDeletePrjCtrl}" checkSecureRequestToken="true" processMethod="deleteOrganisation">
<ips:ctrl_div>
<c:if test="${fn:length(organisationDeletePrjCtrl.item.accounts) > 0 }">
<p><span style="color:red"><fmt:message key="organisation.delete.associated_accounts"/></span></p>
<ul>
<c:forEach items="${organisationDeletePrjCtrl.item.accounts}" var="oa">
<li><c:out value="${oa.login}"/></li>
</c:forEach>
</ul>
</c:if>
<ips:bview bean="${organisationDeletePrjCtrl.item}" actionCommand="delete" props="*" tableClass="db" >
<ips:pview name="persons" var="orgaPersons">
<tr><td><ips:pdescr/></td>
  <td>
   <c:if test="${fn:length(orgaPersons) > 0 }"><span style="color:red"></c:if>#<c:out value="${fn:length(orgaPersons)}"/><c:if test="${fn:length(orgaPersons) > 0 }"></span></c:if>
   </td>
   </tr>
</ips:pview>
<ips:pview name="accounts" var="orgaAccs">
 <tr><td><ips:pdescr/></td>
  <td>
   <c:if test="${fn:length(orgaAccs) > 0 }">
    <table border="1">
     <tr><th><span style="color:red"><fmt:message key="delete"/></span></th><th><fmt:message bundle="${beans}" key="login"/></th></tr>
     <c:forEach items="${orgaAccs}" var="orgaAcc">
     <!-- Force deleting the organization accounts -->
     <tr><td><input type="checkbox" name="_delete_rel.accounts.login" disabled="disabled" readonly="readonly" value="<c:out value="${orgaAcc.login}"/>" checked="checked"/></td><td><c:out value="${orgaAcc.login}"/></td></tr>
     </c:forEach>
    </table>
   </c:if>
   <c:if test="${fn:length(orgaAccs) == 0 }"><fmt:message key="none"/></c:if>
  </td>
 </tr>
</ips:pview>
<ips:pview name="sessions" action="../session/Sessions.jsp"/>
<ips:pview name="projects" action="../project/Projects.jsp" maxListLength="2"/>
</ips:bview>
<p class="warn"><fmt:message key="deletion.cannot.be.undone"/></p>
</ips:ctrl_div>
<ips:ctrl_div result="success">
<p><fmt:message key="organisation.delete.confirm"><fmt:param value="${organisationDeletePrjCtrl.item.name}"/></fmt:message></p>
</ips:ctrl_div>
<ips:ctrl_div result="cancel">
<p><fmt:message key="cancelled"/></p>
</ips:ctrl_div>
<ips:ctrl_div result="error">
<p><fmt:message key="error"/></p>
</ips:ctrl_div>
</ips:ctrl_process>
</td></tr>
</table>
</body>
</html>
