<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"  %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt" %>
<%@ taglib uri="/ips" prefix="ips" %>
<%@ taglib uri="/wsp" prefix="wsp" %>
<%@ page  isELIgnored="false" contentType="text/html; charset=UTF-8" session="true" errorPage="/errorPage.jsp" %>
<fmt:setBundle basename="Messages" scope="page"/>

<html>
<head>
<script src="<c:url value="/lib/script/ips_lib.js"/>" type="text/javascript"></script>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
<%@ include file="/stylesheets.jsp" %>
<title><wsp:appTitle/> - <fmt:message key="project.export.data"/></title>
</head>

<BODY  onload="ips_startUpdate()">
 <table class="page">
 <tr><td colspan="2"><%@ include file="/logoTd.jsp" %></td></tr>
 <tr><td class="contentw" colspan="2"><%@ include file="/titletoolbar.jsp" %></td></tr>
 <tr><td class="menu"><%@ include file="/menu.jsp" %></td>
 <td class="content">
 <h2><fmt:message key="project.export.data"/></h2>
 <p><b>Export the project data as ZIP archive file. The archive will contain project information, all sessions with XML speaker and session informations and all recordings.</b></p>
<p>Press '<fmt:message key="start"/>' to build the ZIP archive on the server. When the archive is ready the 'ZIP Download' button will be enabled. Press this button to download the ZIP archive file to your desktop.</p> 
<jsp:useBean id="projectExportCtrl" scope="session" type="ipsk.webapps.db.speech.ProjectExportController"  />
<jsp:setProperty name="projectExportCtrl" property="ajaxPageContext" value="${pageContext}"/>
<c:if test="${projectExportCtrl.busy == true}">
<c:if test="${projectExportCtrl.projectName != param['name']}">
<p><span style="color:red">Cannot export Project <c:out value="${param['name']}"/>! Export of project <c:out value="${projectExportCtrl.projectName}"/> is currently in progress! Please wait until current export is finished or cancel current export.</span></p>
</c:if>
</c:if>
<p><b><fmt:message key="project"/>: <c:out value="${projectExportCtrl.projectName}"/></b></p>
<p><fmt:message key="status"/>: <span id="status"><c:out value="${projectExportCtrl.statusMessage}"/></span></p>

<form action="<c:url value="/prjdb/project/ProjectExport"/>">
<input type="hidden" name="includeOriginalRecordingFiles" value="false">
<input type="hidden" name="includePCMConvertedFiles" value="false">
<input type="hidden" name="includePCMPickedChannelFiles" value="true"/>
<input type="hidden" name="name" value="${projectExportCtrl.projectName}">
<input id="actionButton" type="submit" name="_${projectExportCtrl.command}" value="<fmt:message key="${projectExportCtrl.command}"/>"/>
<noscript><input type="submit" name="_update_view" value="<fmt:message key="update"/>"/></noscript>
</form>

<p>Download:</p>
<form action="<c:url value="${projectExportCtrl.exportArchivePath}"/>">
<c:choose>
<c:when test="${projectExportCtrl.downloadAvailable}">
<input id="archive_link" type="submit" name="_download" value="ZIP Download"/>
</c:when>
<c:otherwise>
<input id="archive_link" disabled type="submit" name="_download" value="ZIP Download"/>
</c:otherwise>
</c:choose>
</form>

</td></tr>
</table>
</body>
</html>
