<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"  %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt" %>
<%@ taglib uri="/ips" prefix="ips" %>
<%@ taglib uri="/wsp" prefix="wsp" %>
<%@ page  isELIgnored="false" contentType="text/html; charset=UTF-8" session="true" errorPage="/errorPage.jsp" %>
<fmt:setBundle basename="Messages" scope="request"/>
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
<%@ include file="/stylesheets.jsp" %>
<title><wsp:appTitle/> - <fmt:message key="speakers"/></title>
</head>

<body>
 <table class="page">
 <tr><td colspan="2"><%@ include file="/logoTd.jsp" %></td></tr>
 <tr><td class="contentw" colspan="2"><%@ include file="/titletoolbar.jsp" %></td></tr>
 <tr><td class="menu"><%@ include file="/menu.jsp" %></td>
 <td class="content">
 <h2><fmt:message key="speakers"/></h2>

<jsp:useBean id="spksDb" scope="session" class="ipsk.webapps.db.speech.SpeakerController" />
<ips:ctrl_process controller="${spksDb}" processMethod="allSpeakersByAccount">

<ips:boolExpr/><br>
<ips:orderby/><br>

<ips:btable tableClass="db" beanVar="spk" additionalCols="recordingFileCount,_accountMerged" defColOrder="personId,code,project,registered,organisations,_accountMerged,registeredByAccount,informedConsents,sessions">
<ips:col name="project" href="../project/ProjectView.jsp"/>
<ips:col name="informedConsents" href="../informedconsent/InformedConsents.jsp"/>
<ips:col name="organisations" href="../organisation/Organisations.jsp" maxListLength="1"/>
<ips:col name="sessions" href="../session/Sessions.jsp"/>
<ips:col name="registeredByAccount" href="../account/AccountView.jsp"/>
<ips:col name="recordingFileCount" key="recording_files">
<c:set var="spk_sessions" value="${spk.sessions}"/>
<c:set var="rfs" value="0"/>
<c:if test="${not empty spk_sessions}">
<c:forEach items="${spk_sessions}" var="sess"><c:set var="rfs" value="${rfs + fn:length(sess.recordingFiles)}"/></c:forEach></c:if>
<td>#<c:out value="${rfs}"/></td>
</ips:col>

<ips:col name="_accountMerged" key="account">
<c:set var="spk_sessions" value="${spk.sessions}"/>
<c:choose>
<c:when test="${not empty spk.account}">
<c:url var="spkAccUrl" value="../account/AccountView.jsp">
<c:param name="login" value="${spk.account.login}"/>
<c:param name="_cmd" value="view"/>
</c:url>
<td><a href="${spkAccUrl}"><c:out value="${spk.account}"/></a></td>
</c:when>
<c:otherwise>
<c:choose>
<c:when test="${not empty spk.speakerDataAccount}">
<c:url var="spkAccUrl" value="../account/AccountView.jsp">
<c:param name="login" value="${spk.speakerDataAccount.login}"/>
<c:param name="_cmd" value="view"/>
</c:url>
<td><a href="${spkAccUrl}"><c:out value="${spk.speakerDataAccount}"/></a></td>
</c:when>
<c:otherwise>
<!--  Empty table cell -->
<td></td>
</c:otherwise>
</c:choose>
</c:otherwise>
</c:choose>

</ips:col>

<ips:btrowaction name="view" href="SpeakerView.jsp"/>
<ips:btrowaction name="session.new">
 <c:choose>
  <c:when test="${spksDb.speakerHasInformedConsentForSelectedProject(spk) and spksDb.speakerDataComplete(spk) }">
   <c:url value="/session/db/session/SessionNew.jsp" var="sessionNewHref">
			<c:param name="_cmd" value="new"/>
			<c:param name="project.name" value="${spksDb.selectedProject.name}"/>	
			<c:param name="speakers.personId" value="${spk.personId}"/>
			<c:param name="type" value="NORM"/>
			<c:param name="code" value="${spksDb.selectedProject.sessionCode}"/>
   </c:url>
   <a href="${sessionNewHref}">[<fmt:message key="session.new"/>]</a>
  </c:when>
  <c:otherwise>
   <c:url var="editSpeakerURL" value="/session/db/speaker/SpeakerEdit.jsp">
    <c:param name="_cmd" value="edit" />
    <c:param name="personId" value="${spk.personId}" />
   </c:url>
   <a href="${editSpeakerURL}">[<fmt:message key="session.new"/>]</a>
  </c:otherwise>
 </c:choose>
</ips:btrowaction>
<ips:btrowaction href="SpeakerDelete.jsp" name="delete_request"/>

<ips:btcustomize/>
</ips:btable>
<ips:page_navigation/>
<ips:page_position/>
<ips:items_position/>
</ips:ctrl_process>

</td></tr>
</table>
</body>
</html>
