<!doctype html>
<%@ page  isELIgnored="false" contentType="text/html;charset=UTF-8" session="true" errorPage="/errorPage.jsp" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"  %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt" %>
<%@ taglib uri="/ips" prefix="ips" %>
<%@ taglib uri="/wsp" prefix="wsp" %>
<fmt:setBundle basename="Messages" scope="request"/>
<!--[if lt IE 7]>      <html class="no-js lt-ie9 lt-ie8 lt-ie7"> <![endif]-->
<!--[if IE 7]>         <html class="no-js lt-ie9 lt-ie8"> <![endif]-->
<!--[if IE 8]>         <html class="no-js lt-ie9"> <![endif]-->
<!--[if gt IE 8]><!--> <html style="height:100%;margin:0;padding:0"> <!--<![endif]-->
<c:set value="/lib/app" var="basePath"/>
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
      <title>webSpeechRecorder 0.0.9</title>
    <meta name="description" content="">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <!-- Place favicon.ico and apple-touch-icon.png in the root directory -->
      <!--<link href="bower_components/bootstrap/dist/css/bootstrap.min.css" rel="stylesheet">-->
      <link rel="stylesheet" href="<c:url value="${basePath}/styles/main.css"/>">
    <!-- build:js scripts/vendor/modernizr.js -->
    <script src="<c:url value="${basePath}/bower_components/modernizr/modernizr.js"/>"></script>
    <!-- endbuild -->
</head>
<body style="height:100%" onpageshow="speechrecorderInit()">
<div class="container-fluid">
    <div class="navbar navbar-inverse navbar-fixed-top">

        <div class="navbar-header">
            <button type="button" class="navbar-toggle collapsed" data-toggle="collapse" data-target="#navbar"
                    aria-expanded="false" aria-controls="navbar">
            <span class="icon-bar"></span>
            <span class="icon-bar"></span>
            <span class="icon-bar"></span>
          </button>
            <a class="navbar-brand" href="#"><img src="<c:url value="${basePath}/images/speechrecorder_32x32.png"/>"/></a><a class="navbar-brand"
                                                                                                href="#">WikiSpeech</a>
        </div>
        <div id="navbar" class="navbar-collapse collapse">
          <ul class="nav navbar-nav">

          </ul>
            <jsp:include page="/menu_bt.jsp"/>
        </div>
      </div>
      </div>
       <!--<div class="container" style="height:100%">  -->

  <div class="jumbotron">


      <div id="webspeechrecorder"><p id="title">WebSpeechrecorder Demo 1</p></div>
      <div id="prompting">
          <div id="trafficlight">
              <div id="stl_red" class="circle"></div>
              <div id="stl_yellow" class="circle"></div>
              <div id="stl_green" class="circle"></div>
          </div>
        	<div id="prompterContainer" >
           <div id="prompter"><p><span id="prompt">Here is a text ... Lorem ipsum dolor sit amet, consectetur adipiscing elit. Lorem ipsum dolor sit amet, consectetur adipiscing elit. 2</span></p></div>
          </div>
          <div id="progressContainer" class="hidden-xs">
              <table id="progressTable" class="table table-bordered">
                  <thead id="progressTableHeader">
                  <tr>
                      <th>#</th><!--<th>Code</th>-->
                      <th>Prompt</th>
                  </tr>
                  </thead>
                  <tbody id="progressTableBody"/>
              </table>
          </div>
      </div>
       	<!--<div> -->

      <div id="asGrPanel" class="panel-group">
          <div id="asPanel" class="panel panel-default">
              <div class="panel-heading">
                  <h4 class="panel-title">
                      <a id="audioSignalSwitch" data-toggle="collapse" data-parent="#asGrPanel" href="#collapse1">Audio
                          signal <span id="audioSignalCollIcon" class="glyphicon glyphicon-collapse-up"></span></a>

                  </h4>
              </div>
              <div id="collapse1" class="panel-collapse collapse">
                  <div id="audioSignalContainer" class="panel-body"></div>
                  <div id="signalDisplayFooter" class="panel-footer">
                      <div id="audioPlayer">
                          <button id="playStartBtn" class="btn"><span id="playIcon"
                                                                      class="glyphicon glyphicon-play-circle"></span>
                              Play
                          </button>
                      </div>
                    <div id="rfDownload">
                        <a id="rfDownloadLnk" href="#dl">Download as WAV file <span
                                class="glyphicon glyphicon-download"></span></a>
                    </div>

                  </div>
              </div>
          </div>
      </div>

      <div><span id="status">Initializing...</span></div>
      <div id="transportPanel">
          <button id="bwdBtn" class="btn-lg btn-primary"><span class="glyphicon glyphicon-step-backward"></span>
          </button>
        <button id="startBtn" class="btn-lg btn-primary"><span class="glyphicon glyphicon-record"></span> Start</button>
        <button id="stopBtn" class="btn-lg btn-primary"><span class="glyphicon glyphicon-stop"></span> Stop</button>
          <button id="nextBtn" class="btn-lg btn-primary"><span class="glyphicon glyphicon-forward"></span> Next
          </button>
          <button id="pauseBtn" class="btn-lg btn-primary"><span class="glyphicon glyphicon-pause"></span> Pause
          </button>
        <button id="fwdBtn" class="btn-lg btn-primary"><span class="glyphicon glyphicon-step-forward"></span></button>
      </div>

      <div class="progress">
          <span class="glyphicon glyphicon-cloud-upload"></span>
          <div id="uploadProgressBar" class="progress-bar" role="progressbar"
               aria-valuenow="45" aria-valuemin="0" aria-valuemax="100" style="width: 0%">
              0% Upload
          </div>
      </div>

  </div>
  <!--<script src="bower_components/requirejs/require.js" data-main="scripts/ips/apps/speechrecorder/speechrecorder.js"></script>-->
  <script src="<c:url value="${basePath}/bower_components/commonjs/common.js"/>"></script>
  <script src="<c:url value="${basePath}/bower_components/jquery/jquery.js"/>"></script>
  <script src="<c:url value="${basePath}/bower_components/jquery-ui/ui/jquery-ui.js"/>"></script>
  <script src="<c:url value="${basePath}/webspeechrecorder.js"/>"></script>
        <!--<script src="scripts/ips/audio/ui/audiosignal.js"></script>-->
        <!-- endbuild -->

        <!-- build:js scripts/vendor/bootstrap.js -->
<script src="<c:url value="${basePath}/bower_components/bootstrap/js/affix.js"/>"></script>
  <script src="<c:url value="${basePath}/bower_components/bootstrap/js/alert.js"/>"></script>
  <script src="<c:url value="${basePath}/bower_components/bootstrap/js/dropdown.js"/>"></script>
  <script src="<c:url value="${basePath}/bower_components/bootstrap/js/tooltip.js"/>"></script>
  <script src="<c:url value="${basePath}/bower_components/bootstrap/js/modal.js"/>"></script>
  <script src="<c:url value="${basePath}/bower_components/bootstrap/js/transition.js"/>"></script>
  <script src="<c:url value="${basePath}/bower_components/bootstrap/js/button.js"/>"></script>
  <script src="<c:url value="${basePath}/bower_components/bootstrap/js/popover.js"/>"></script>
  <script src="<c:url value="${basePath}/bower_components/bootstrap/js/carousel.js"/>"></script>
  <script src="<c:url value="${basePath}/bower_components/bootstrap/js/scrollspy.js"/>"></script>
  <script src="<c:url value="${basePath}/bower_components/bootstrap/js/collapse.js"/>"></script>
<script src="<c:url value="${basePath}/bower_components/bootstrap/js/tab.js"/>"></script>

        <!-- endbuild -->
<!--<script src="bower_components/bootstrap/dist/js/bootstrap.min.js"/>-->
</body>
</html>
