function screen2paper(varargin)
% function screen2paper([scale_factor=1, [width_on_paper, height_on_paper]])
%
%   scale_factor: scaling when converting from screen to paper
%   width_on_paper, height_on_paper: for size for paper version
%                                    otherwise: report only sizes
%                                    and set only paper size.
% CVS_Version_String = '$Id: screen2paper.m,v 1.8 2004/04/28 17:38:55 tuerk Exp $';
% CVS_Name_String = '$Name: rel-1-4-01 $';

% ###########################################################
%
% This file is part of the matlab scripts of the MASV System.
% MASV = Munich Automatic Speaker Verification
%
% Copyright 2002-2003, Ulrich Trk
% Institute of Phonetics and Speech Communication
% University of Munich
% tuerk@phonetik.uni-muenchen.de
%
%
%   MASV is free software; you can redistribute it and/or modify
%   it under the terms of the GNU General Public License as published by
%   the Free Software Foundation; either version 2 of the License, or
%   (at your option) any later version.
%
%   MASV is distributed in the hope that it will be useful,
%   but WITHOUT ANY WARRANTY; without even the implied warranty of
%   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%   GNU General Public License for more details.
%
%   You should have received a copy of the GNU General Public License
%   along with MASV; if not, write to the Free Software
%   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
%
% ###########################################################

screen_dpi = 72;

if (nargin >= 1),
	scale_factor = varargin{1};
else
	scale_factor = 1;
end	

if (nargin == 3),
	width_paper = varargin{2};
	height_paper = varargin{3};
	flag_resize_figure = 1;
else
	flag_resize_figure = 0;
end	


set(gcf,'PaperUnit', 'centimeter');
Pos = get(gcf,'Position');


if (flag_resize_figure),
	NPos(3)=width_paper;
	NPos(4)=height_paper;
	Pos(3) = width_paper * screen_dpi / 2.54 / scale_factor;
	Pos(4) = height_paper * screen_dpi / 2.54 / scale_factor;
	set(gcf,'Position',Pos);
	set(gcf,'PaperPosition', NPos);
else
	NPos(3) = Pos(3) / screen_dpi * 2.54 * scale_factor;
	NPos(4) = Pos(4) / screen_dpi * 2.54 * scale_factor;
	NPos(1) = 0.5;
	NPos(2) = 6;
	set(gcf,'PaperPosition', NPos);
end

	disp(['Width on paper: ' num2str(NPos(3)) 'cm'])
	disp(['Height on paper: ' num2str(NPos(4)) 'cm'])
	disp(['Width on screen: ' num2str(Pos(3)) 'Pixel'])
	disp(['Height on screen: ' num2str(Pos(4)) 'Pixel'])

