function coeff = HTK_SigP_Wave2FBank(frame,Fs,numChans, melcoeff, info, takeLogs, mode)
% function coeff = HTK_SigP_Wave2FBank(frame,Fs,numChans, melcoeff, info, takeLogs, mode)
%
% CVS_Version_String = '$Id: HTK_SigP_Wave2FBank.m,v 1.8 2004/03/29 14:01:06 tuerk Exp $';
% CVS_Name_String = '$Name: rel-1-4-01 $';

% ###########################################################
%
% This file is part of the matlab scripts of the MASV System.
% MASV = Munich Automatic Speaker Verification
%
% Copyright 2002-2003, Ulrich Trk
% Institute of Phonetics and Speech Communication
% University of Munich
% tuerk@phonetik.uni-muenchen.de
%
%
%   MASV is free software; you can redistribute it and/or modify
%   it under the terms of the GNU General Public License as published by
%   the Free Software Foundation; either version 2 of the License, or
%   (at your option) any later version.
%
%   MASV is distributed in the hope that it will be useful,
%   but WITHOUT ANY WARRANTY; without even the implied warranty of
%   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%   GNU General Public License for more details.
%
%   You should have received a copy of the GNU General Public License
%   along with MASV; if not, write to the Free Software
%   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
%
% ###########################################################


	melfloor = 1;

	
	if (size(frame,2) ~= 1)
		frame = frame';
	end

	fftSize = 2^(ceil(log2(length(frame))));
	
	if (strcmp(mode,'matlab')),
		SpecFrame = fft(frame,fftSize);
		fbank = melcoeff * abs(SpecFrame(1:(1+floor(fftSize/2))));

		if (takeLogs)
			fbank = log( max( [ ones(length(fbank),1)  fbank ], [], 2 ) );
		end

		coeff = fbank;
		return;
	else
		
		
		padded_frame=zeros(fftSize,1);
		padded_frame(1:length(frame))=frame;
		SpecFrame=HTK_realft(padded_frame);		
		
			fbank=zeros(info.numChans,1); 
			for k = info.klo:info.khi            % /* fill bins */
				t1 = SpecFrame(2*k-1);
				t2 = SpecFrame(2*k);
				if (info.usePower)
					ek = t1*t1 + t2*t2;
				else
					ek = sqrt(t1*t1 + t2*t2);
				end
				bin = info.loChan(k);
				t1 = info.loWt(k)*ek;
				if (bin>0)
					fbank(bin) = fbank(bin) + t1;
				end
				if (bin<info.numChans) 
					fbank(bin+1) = fbank(bin+1) + (ek - t1);
				end
			end
			
			%/* Take logs */
			if (takeLogs)
				for bin=1:info.numChans
					t1 = fbank(bin);
					if (t1<melfloor) 
						t1 = melfloor;
					end
					fbank(bin) = log(t1);
				end
			end
	
		coeff = fbank;

	end
