function [eer, eer_coarse, threshold, threshold_coarse, fa_hits, fr_hits, fa_N_tests, fr_N_tests] = calc_EER_no_smoothing(FR_borders_in,FA_borders_in, plot_flag)
% function [eer, eer_coarse, threshold, threshold_coarse, fa_hits, fr_hits, fa_N_tests, fr_N_tests] = calc_EER_no_smoothing(FR_borders_in,FA_borders_in, plot_flag)
%
%
% CVS_Version_String = '$Id: calc_EER_no_smoothing.m,v 1.9 2004/05/06 13:40:20 tuerk Exp $';
% CVS_Name_String = '$Name: rel-1-4-01 $';

% ###########################################################
%
% This file is part of the matlab scripts of the MASV System.
% MASV = Munich Automatic Speaker Verification
%
% Copyright 2002-2003, Ulrich Trk
% Institute of Phonetics and Speech Communication
% University of Munich
% tuerk@phonetik.uni-muenchen.de
%
%
%   MASV is free software; you can redistribute it and/or modify
%   it under the terms of the GNU General Public License as published by
%   the Free Software Foundation; either version 2 of the License, or
%   (at your option) any later version.
%
%   MASV is distributed in the hope that it will be useful,
%   but WITHOUT ANY WARRANTY; without even the implied warranty of
%   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%   GNU General Public License for more details.
%
%   You should have received a copy of the GNU General Public License
%   along with MASV; if not, write to the Free Software
%   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
%
% ###########################################################



	if (nargin == 2)
		plot_flag = 0;
	end
	
	FR_borders = sort(FR_borders_in);

	FA_borders = sort(FA_borders_in);


	fa_N_tests = length(FA_borders);
	fr_N_tests = length(FR_borders);

	if (isempty(FR_borders) | isempty(FA_borders)),
		eer = NaN;
		eer_coarse = NaN;
		threshold = NaN;
		threshold_coarse = NaN;
		fa_hits = NaN;
		fr_hits = NaN;
		return;
	end
	
	probabilities_fr = (1:fr_N_tests) / fr_N_tests * 100;
	
	probabilities_fa = (1:fa_N_tests) / fa_N_tests * 100;
	probabilities_fa = [(100 - probabilities_fa)];

	% find duplicate values
	%keyboard;
	temp=diff(FR_borders);
	dup_indizes = find(temp==0);
	if (~(isempty(dup_indizes))),
	
		
		prob_counter=0;
		dup_indizes=sort(dup_indizes);
		current_dup_index_pointer=1;
		probabilities_fr_new=zeros(1, length(FR_borders));
		for i=1:length(FR_borders),		
			if ( (current_dup_index_pointer <= length(dup_indizes) ) & (i == dup_indizes(current_dup_index_pointer) ) ),
				current_dup_index_pointer = current_dup_index_pointer + 1;
				prob_counter = prob_counter + 1;
			else
				prob_counter = prob_counter + 1;
				if (prob_counter > fr_N_tests),
					break;
				end
				probabilities_fr_new(i) = prob_counter * ( 1/fr_N_tests) * 100;
			end
		end
		probabilities_fr = remove_vector_items(probabilities_fr_new, dup_indizes);
		FR_borders=remove_vector_items(FR_borders, dup_indizes+1);
	end
	


	
	temp=diff(FA_borders);
	dup_indizes = find(temp==0);
	if (~(isempty(dup_indizes))),
	
		
		prob_counter=0;
		dup_indizes=sort(dup_indizes);
		current_dup_index_pointer=1;
		probabilities_fa_new=zeros(1, length(FA_borders));
		for i=1:length(FA_borders),		
			if ( (current_dup_index_pointer <= length(dup_indizes) ) & (i == dup_indizes(current_dup_index_pointer) ) ),
				current_dup_index_pointer = current_dup_index_pointer + 1;
				prob_counter = prob_counter + 1;
			else
				prob_counter = prob_counter + 1;
				if (prob_counter > fa_N_tests),
					break;
				end
				probabilities_fa_new(i) = 100 - ( prob_counter * ( 1/fa_N_tests) * 100 );
			end
		end
		FA_borders=remove_vector_items(FA_borders, dup_indizes+1);
		probabilities_fa = remove_vector_items(probabilities_fa_new, dup_indizes);
	end
	
	
	%keyboard;
	FA_borders = [(FA_borders(1)-0.001*abs(FA_borders(1))) FA_borders];
	probabilities_fa  = [100 probabilities_fa];

	FR_borders = [(FR_borders(1)-0.001*abs(FR_borders(1))) FR_borders];
	probabilities_fr  = [0 probabilities_fr];
	
	
	
	concat_borders = [FR_borders FA_borders];
	borders_common = sort(concat_borders);

	
	% linear interpolation on borders_common
	prob_fr_interpl = interp1(FR_borders, probabilities_fr, borders_common, 'linear');
	prob_fa_interpl = interp1(FA_borders, probabilities_fa, borders_common, 'linear');
	
	% fill non-interpolated areas with 0
	%
	existing_values_ind = find(~isnan(prob_fr_interpl));
	low_area_end = min(existing_values_ind) - 1;
	if (~isempty(low_area_end)),
		prob_fr_interpl(1:low_area_end) = 0;
	end
	
	high_area_begin = max(existing_values_ind) + 1;
	if (~isempty(high_area_begin)),
		prob_fr_interpl(high_area_begin:end) = 100;
	end
	%
	existing_values_ind = find(~isnan(prob_fa_interpl));
	low_area_end = min(existing_values_ind) - 1;
	if (~isempty(low_area_end)),
		prob_fa_interpl(1:low_area_end) = 100;
	end
	
	high_area_begin = max(existing_values_ind) + 1;
	if (~isempty(high_area_begin)),
		prob_fa_interpl(high_area_begin:end) = 0;
	end

	


	

	intercept_indizes = find ( (prob_fr_interpl -  prob_fa_interpl ) == 0 );
	if (length(intercept_indizes) > 1),
		intercept_index_start = min(intercept_indizes);
		intercept_index_end = max(intercept_indizes);
		eer = mean( [ prob_fr_interpl(intercept_index_start) prob_fr_interpl(intercept_index_end) ] );
		threshold = mean( [ borders_common(intercept_index_start) borders_common(intercept_index_end) ] );
		eer_coarse = eer;
		
		threshold_coarse = min(abs(FR_borders(2:end) - threshold));
		
	else
		intercept_indizes = find ( (prob_fr_interpl -  prob_fa_interpl ) <= 0 );
		intercept_index = max(intercept_indizes);
		fr_coarse = prob_fr_interpl(intercept_index);
		fa_coarse = prob_fa_interpl(intercept_index);
		fr_raw_index = min(find( (probabilities_fr - fr_coarse) >= 0));
		fa_raw_index = max(find( (probabilities_fa - fa_coarse) >= 0));
	
		eer = mean( [ prob_fr_interpl(intercept_index) prob_fr_interpl(min(intercept_index+1, length(prob_fr_interpl))) ] );
		threshold = mean( [ borders_common(intercept_index) borders_common(min(intercept_index+1, length(borders_common))) ] );
		
		distance_real_to_interp_fa=abs(probabilities_fa(fa_raw_index) - fa_coarse);
		distance_real_to_interp_fr=abs(probabilities_fr(fr_raw_index) - fr_coarse);
		if (distance_real_to_interp_fa > distance_real_to_interp_fr),
			eer_coarse = probabilities_fr(fr_raw_index);
			threshold_coarse = FR_borders(fr_raw_index);
		else
			eer_coarse = probabilities_fa(fa_raw_index);
			threshold_coarse = FA_borders(fa_raw_index);
		end

	end
	fr_hits = length(find( FR_borders(2:end) < threshold_coarse));
	fa_hits = length(find( FA_borders(2:end) > threshold_coarse));
	
	
	
	
	
	if (plot_flag == 1)
		if (isempty(get(0,'CurrentFigure')))
			temp_figure_handle = [];
		else
			temp_figure_handle = gcf;
		end
		figure;
		plot(FR_borders,probabilities_fr,'w*');
		hold on;
		plot(FA_borders, probabilities_fa ,'y*');
		plot(threshold_coarse, eer_coarse, 'gx');
		if ~(isempty(temp_figure_handle)),
			figure(temp_figure_handle);
		end
	end



	
		
