function score_result_struct = calc_score_result_cmn_part(score_result_struct, part_index, result_struct, ext_model_info, included_models, imp_spks_list, fr_sel_sessions, fa_sel_sessions, base_part_type)
% function score_result_struct = calc_score_result_cmn_part(score_result_struct, 
%                                part_index, result_struct, ext_model_info, included_models, imp_spks_list,
%                                fr_sel_sessions, fa_sel_sessions, base_part_type)
%
% CVS_Version_String = '$Id: calc_score_result_cmn_part.m,v 1.26 2004/06/01 08:27:09 tuerk Exp $';
% CVS_Name_String = '$Name: rel-1-4-01 $';

% ###########################################################
%
% This file is part of the matlab scripts of the MASV System.
% MASV = Munich Automatic Speaker Verification
%
% Copyright 2002-2003, Ulrich Trk
% Institute of Phonetics and Speech Communication
% University of Munich
% tuerk@phonetik.uni-muenchen.de
%
%
%   MASV is free software; you can redistribute it and/or modify
%   it under the terms of the GNU General Public License as published by
%   the Free Software Foundation; either version 2 of the License, or
%   (at your option) any later version.
%
%   MASV is distributed in the hope that it will be useful,
%   but WITHOUT ANY WARRANTY; without even the implied warranty of
%   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%   GNU General Public License for more details.
%
%   You should have received a copy of the GNU General Public License
%   along with MASV; if not, write to the Free Software
%   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
%
% ###########################################################



	num_of_models = length(included_models);

	[male_indizes, female_indizes]	= get_gender_indizes(included_models, ext_model_info);

	N_imp_spks_per_model = [];
	
	for i=1:num_of_models,
		absolute_index = strmatch(included_models(i), ext_model_info.trained_models,'exact');
		current_speaker = result_struct.FR_struct{absolute_index}.model_name;
		imp_spks_names = get_imp_speakers(imp_spks_list, {current_speaker}, result_struct.model_info, result_struct.FA_struct{absolute_index}.imp_test_spks);

		N_imp_spks_per_model(i) = length(imp_spks_names);		
		
		fa_rec_indizes = find_sessions_in_F_struct(result_struct.FA_struct{absolute_index}, fa_sel_sessions, imp_spks_names, ext_model_info);
		
		
		session_filtered_FA_struct{i}.data.borders = result_struct.FA_struct{absolute_index}.data.borders(fa_rec_indizes);
		session_filtered_FA_struct{i}.data.rec_info = result_struct.FA_struct{absolute_index}.data.rec_info(fa_rec_indizes,:);
		session_filtered_FA_struct{i}.model_name = result_struct.FA_struct{absolute_index}.model_name;
		session_filtered_FA_struct{i}.imp_spks = imp_spks_names;
		
		fr_rec_indizes = find_sessions_in_F_struct(result_struct.FR_struct{absolute_index}, fr_sel_sessions, {'all'}, ext_model_info);

		session_filtered_FR_struct{i}.data.borders = result_struct.FR_struct{absolute_index}.data.borders(fr_rec_indizes);
		session_filtered_FR_struct{i}.data.rec_info = result_struct.FR_struct{absolute_index}.data.rec_info(fr_rec_indizes,:);
		session_filtered_FR_struct{i}.model_name = result_struct.FR_struct{absolute_index}.model_name;
		
	end
	
	disp('Calculating fa rates ...');
	disp('... fa rates and score parameters against client speakers');
	for i=1:num_of_models,
		disp(['model ' num2str(i), ', ' session_filtered_FA_struct{i}.model_name]);
		reduced_FA_struct=decompose_F_struct(session_filtered_FA_struct{i},session_filtered_FA_struct{i}.imp_spks, 'with rec_info');
		for j=1:length(reduced_FA_struct.data),
			[fa, fa_coarse, fa_hits, fa_N_tests] = find_FA_coarse(reduced_FA_struct.data(j), score_result_struct.part{part_index}.model(i).data.threshold_coarse, 'lin_interpolation');
			score_result_struct.part{part_index}.model(i).data.fa_imposter(j) = fa_coarse;
			score_result_struct.part{part_index}.model(i).data.fa_imposter_hits(j) = fa_hits;
			score_result_struct.part{part_index}.model(i).data.fa_imposter_N_tests(j) = fa_N_tests;
			score_result_struct.part{part_index}.model(i).imp_spks = session_filtered_FA_struct{i}.imp_spks;
			score_result_struct.part{part_index}.model(i).data.imp_score_mean(j) = mean(reduced_FA_struct.data(j).borders);
			score_result_struct.part{part_index}.model(i).data.imp_score_std(j) = std(reduced_FA_struct.data(j).borders);
			
			% max impostor score with corresponding score of model speaker
			[temp_imp_score index_max] = max(reduced_FA_struct.data(j).borders);
			complete_rec_string = reduced_FA_struct.data(j).rec_info(index_max,:);
			session_rec_string = complete_rec_string(6:end);
			model_score_index = find_session_rec_string(session_filtered_FR_struct{i}.data.rec_info, session_rec_string);
			if (model_score_index ~= 0),
				score_result_struct.part{part_index}.model(i).data.imp_score_max(j).model_score = session_filtered_FR_struct{i}.data.borders(model_score_index);
				score_result_struct.part{part_index}.model(i).data.imp_score_max(j).imp_score = temp_imp_score;
			else
				score_result_struct.part{part_index}.model(i).data.imp_score_max(j).model_score = NaN;
				score_result_struct.part{part_index}.model(i).data.imp_score_max(j).imp_score = temp_imp_score;
			end
		end
		score_result_struct.part{part_index}.model(i).data.fa_against_client_mean = mean(score_result_struct.part{part_index}.model(i).data.fa_imposter);
	end
	
	disp('... fa rates in favour imposters');		
	
	fa_infavour_imp_array = [];
	fa_hits_infavour_imp_array = [];
	for i=1:num_of_models,
		for j=1:length(score_result_struct.part{part_index}.model(i).data.fa_imposter),
			absolute_imp_index = strmatch(score_result_struct.part{part_index}.model( i ).imp_spks(j), score_result_struct.model_info.imp_test_spks,'exact');
			fa_infavour_imp_array(i,absolute_imp_index) = score_result_struct.part{part_index}.model(i).data.fa_imposter(j);
			fa_hits_infavour_imp_array(i,absolute_imp_index) = score_result_struct.part{part_index}.model(i).data.fa_imposter_hits(j);
		end
	end
	score_result_struct.part{part_index}.parameters.fa_hits_infavour_imp_a = fa_hits_infavour_imp_array;
	score_result_struct.part{part_index}.parameters.fa_hits_infavour_imp = 	sum(fa_hits_infavour_imp_array); % mean over client models
	score_result_struct.part{part_index}.parameters.fa_infavour_imp = mean(fa_infavour_imp_array); % mean over client models
	

	temp_sum = 0;
	for i=1:num_of_models,
		temp_vector = [score_result_struct.part{part_index}.model(i).data.fa_imposter];
		temp_sum = temp_sum + mean(temp_vector);
	end
	score_result_struct.part{part_index}.parameters.fa_mean = temp_sum / (num_of_models);

	temp_sum = 0;
	for i=1:length(male_indizes),
		temp_vector = [score_result_struct.part{part_index}.model(male_indizes(i)).data.fa_imposter];
		temp_sum = temp_sum + mean(temp_vector);
	end
	score_result_struct.part{part_index}.parameters.fa_male_mean = temp_sum / (length(male_indizes));
	

	temp_sum = 0;
	for i=1:length(female_indizes),
		temp_vector = [score_result_struct.part{part_index}.model(female_indizes(i)).data.fa_imposter];
		temp_sum = temp_sum + mean(temp_vector);
	end
	score_result_struct.part{part_index}.parameters.fa_female_mean = temp_sum / (length(female_indizes));

	score_result_struct.part{part_index}.parameters.fa_gender_balanced_mean = mean([score_result_struct.part{part_index}.parameters.fa_male_mean score_result_struct.part{part_index}.parameters.fa_female_mean]);
	
	
	disp('Calculating relative unreliability')
	if (strcmp(base_part_type, 'eer'))
		total_sum_of_fr_per_model = sum(get_nested_field(score_result_struct.part{part_index}.model,'data.eer'));
		for i = 1:num_of_models,
						score_result_struct.part{part_index}.parameters.rel_unreliability(i) = score_result_struct.part{part_index}.model(i).data.eer / total_sum_of_fr_per_model;
		end
	elseif (sum(strcmp(base_part_type, {'fr_fa';'det'})))
		total_sum_of_fr_per_model = sum(get_nested_field(score_result_struct.part{part_index}.model,'data.fr'));
		for i = 1:num_of_models,
						score_result_struct.part{part_index}.parameters.rel_unreliability(i) = score_result_struct.part{part_index}.model(i).data.fr / total_sum_of_fr_per_model;
		end
	else
		
	end
	disp('Calculating relative vulnerability')

	% get beta dash
	temp_fa_array = [];
	for i=1:num_of_models,
		for j=1:length(score_result_struct.part{part_index}.model(i).data.fa_imposter),
			absolute_imp_index = strmatch(score_result_struct.part{part_index}.model(i).imp_spks(j), score_result_struct.model_info.imp_test_spks,'exact');
			temp_fa_array(i,absolute_imp_index) = score_result_struct.part{part_index}.model(i).data.fa_imposter(j);
		end
	end
	score_result_struct.part{part_index}.parameters.fa_mean_from_beta_dash = mean(mean(temp_fa_array));
	fa_total_sum = sum(sum(temp_fa_array));

	
	% rel. vulnerability
	for i = 1:num_of_models,
		fa_against_client_sum = sum(score_result_struct.part{part_index}.model(i).data.fa_imposter);
		score_result_struct.part{part_index}.parameters.rel_vulnerability(i) = fa_against_client_sum / fa_total_sum;
	end


	disp('Calculating relative imitation ability')

	fa_infavour_imp_sum = sum(fa_infavour_imp_array);
	score_result_struct.part{part_index}.parameters.rel_imitation_ability = fa_infavour_imp_sum / fa_total_sum;

	
	
	disp('Calculating fr data statistics')
	if (strcmp(base_part_type, 'eer'))
		fr_vector = get_nested_field(score_result_struct.part{part_index}.model,'data.eer');
	elseif (sum(strcmp(base_part_type, {'fr_fa';'det'})))
		fr_vector = get_nested_field(score_result_struct.part{part_index}.model,'data.fr');
	else
		
	end
	score_result_struct.part{part_index}.parameters.fr_vector = fr_vector;

	score_result_struct.part{part_index}.parameters.fr_mean = mean(fr_vector);


	score_result_struct.part{part_index}.parameters.fr_male_mean = mean(fr_vector(male_indizes));
	score_result_struct.part{part_index}.parameters.fr_female_mean = mean(fr_vector(female_indizes));
	score_result_struct.part{part_index}.parameters.fr_gender_balanced_mean = mean([score_result_struct.part{part_index}.parameters.fr_male_mean score_result_struct.part{part_index}.parameters.fr_female_mean]);

	
	
	
	disp('Calculating score means and variances ...');
	for i=1:num_of_models			
		score_result_struct.part{part_index}.model(i).data.client_score_mean = mean(session_filtered_FR_struct{i}.data.borders);
		score_result_struct.part{part_index}.model(i).data.client_score_std = std(session_filtered_FR_struct{i}.data.borders);
	end


	disp('Calculating stat. significance parameters per model....');

	alpha = 0.05; %error prob.
	z_scale = abs(norminv(alpha/2));

	
	for i=1:num_of_models			
		
		
		% rule of 3
		score_result_struct.part{part_index}.model(i).data.client_low_p_bound_rule3 = 3/score_result_struct.part{part_index}.model(i).data.fr_N_tests * 100;
		score_result_struct.part{part_index}.model(i).data.client_low_p_bound_exact = (1 - alpha^(1/score_result_struct.part{part_index}.model(i).data.fr_N_tests) )* 100;

		score_result_struct.part{part_index}.model(i).data.imp_low_p_bound_rule3 = 3/score_result_struct.part{part_index}.model(i).data.fa_N_tests * 100;
		score_result_struct.part{part_index}.model(i).data.imp_low_p_bound_exact = ( 1 - alpha^(1/score_result_struct.part{part_index}.model(i).data.fa_N_tests)) * 100;
		
		score_result_struct.part{part_index}.model(i).data.imp_low_p_bound_rule3_strict = 3/length(session_filtered_FA_struct{i}.imp_spks) * 100;
		score_result_struct.part{part_index}.model(i).data.imp_low_p_bound_exact_strict = ( 1 - alpha^(1/length(session_filtered_FA_struct{i}.imp_spks)) ) * 100;

		% rule of 30
		% fr

		if (score_result_struct.part{part_index}.model(i).data.fr_hits == 0),
			score_result_struct.part{part_index}.model(i).data.client_p_sig_bounds_rule30 = [ 0.0 100.0 ];
		else
			prop_factor = z_scale / sqrt(score_result_struct.part{part_index}.model(i).data.fr_hits);
			if (strcmp(base_part_type, 'eer'))
				base_prob = score_result_struct.part{part_index}.model(i).data.eer;
			elseif (sum(strcmp(base_part_type, {'fr_fa';'det'})))
				base_prob = score_result_struct.part{part_index}.model(i).data.fr;
			end
			
			score_result_struct.part{part_index}.model(i).data.client_p_sig_bounds_rule30 = [ (base_prob*(1-prop_factor)) (base_prob*(1+prop_factor))];
		end
		
		% rule of 30
		% fa
		if (score_result_struct.part{part_index}.model(i).data.fa_hits == 0),
			score_result_struct.part{part_index}.model(i).data.imp_p_sig_bounds_rule30 = [ 0.0 100.0 ];
			score_result_struct.part{part_index}.model(i).data.imp_p_sig_bounds_rule30_strict_using_av = [ 0.0 100.0 ];
		else
			if (strcmp(base_part_type, 'eer'))
				base_prob = score_result_struct.part{part_index}.model(i).data.eer;
			elseif (sum(strcmp(base_part_type, {'fr_fa';'det'})))
				base_prob = score_result_struct.part{part_index}.model(i).data.fa;
			end
			
			prop_factor = z_scale / sqrt(score_result_struct.part{part_index}.model(i).data.fa_hits);
			score_result_struct.part{part_index}.model(i).data.imp_p_sig_bounds_rule30 = [ (base_prob*(1-prop_factor))  (base_prob*(1+prop_factor))];

			fa_imposter= score_result_struct.part{part_index}.model(i).data.fa_imposter; % mean fa for each impostor alone
			fa_hits_mean_per_impostor = sum(fa_imposter); % each impostor is a entity
			prop_factor = z_scale / sqrt(fa_hits_mean_per_impostor);
			score_result_struct.part{part_index}.model(i).data.imp_p_sig_bounds_rule30_strict_using_av = [ (base_prob*(1-prop_factor))  (base_prob*(1+prop_factor))];
		end
		
	end

	av_num_of_imp_spks = sum(N_imp_spks_per_model) / num_of_models;
	
	
	
	disp('Calculating overall stat. significance parameters ....');
	
	fa_hits = score_result_struct.part{part_index}.parameters.fa_hits;
	fa_N_tests = score_result_struct.part{part_index}.parameters.fa_N_tests;
	fr_hits = score_result_struct.part{part_index}.parameters.fr_hits;
	fr_N_tests = score_result_struct.part{part_index}.parameters.fr_N_tests;
	
	
	% rule of 3
	score_result_struct.part{part_index}.parameters.client_low_p_bound_rule3 = 3/fr_N_tests * 100;
	score_result_struct.part{part_index}.parameters.client_low_p_bound_exact = (1 - alpha^(1/fr_N_tests) ) * 100;

	score_result_struct.part{part_index}.parameters.client_low_p_bound_rule3_strict = 3/num_of_models * 100;
	score_result_struct.part{part_index}.parameters.client_low_p_bound_exact_strict = (1 - alpha^(1/num_of_models))*100;

	score_result_struct.part{part_index}.parameters.imp_low_p_bound_rule3 = 3/fa_N_tests * 100;
	score_result_struct.part{part_index}.parameters.imp_low_p_bound_exact = (1 - alpha^(1/fa_N_tests) ) * 100;
		
	score_result_struct.part{part_index}.parameters.imp_low_p_bound_rule3_strict = 3/av_num_of_imp_spks * 100;
	score_result_struct.part{part_index}.parameters.imp_low_p_bound_exact_strict = (1 - alpha^(1/av_num_of_imp_spks)) * 100;

	
	% rule of 30
	% fr

	prop_factor = z_scale / sqrt(score_result_struct.part{part_index}.parameters.fr_hits);
	if (strcmp(base_part_type, 'eer'))
		base_prob = score_result_struct.part{part_index}.parameters.eer_mean;
	elseif (strcmp(base_part_type, 'fr_fa'))
		base_prob = score_result_struct.part{part_index}.parameters.fr_mean;
	elseif (strcmp(base_part_type, 'det'))
		base_prob = score_result_struct.part{part_index}.parameters.eer;
	else

	end
	
	score_result_struct.part{part_index}.parameters.client_p_sig_bounds_rule30 = [ (base_prob*(1-prop_factor)) (base_prob*(1+prop_factor))];
	
	% rule of 30
	% fa
	prop_factor = z_scale / sqrt(score_result_struct.part{part_index}.parameters.fa_hits);
	if (strcmp(base_part_type, 'eer'))
		base_prob = score_result_struct.part{part_index}.parameters.eer_mean;
	elseif (strcmp(base_part_type, 'fr_fa'))
		base_prob = score_result_struct.part{part_index}.parameters.fa_mean;
	elseif (strcmp(base_part_type, 'det'))
		base_prob = score_result_struct.part{part_index}.parameters.eer;
	else

	end
	
	score_result_struct.part{part_index}.parameters.imp_p_sig_bounds_rule30 = [ (base_prob*(1-prop_factor))  (base_prob*(1+prop_factor))];


	
	% fr, multiple attempts per volunteer, each attempt equal weight
	% according 6.2.2, Biometric, Testing Best Practices
	fr_hits_vector = get_nested_field(score_result_struct.part{part_index}.model,'data.fr_hits');
	fr_N_tests_vector = get_nested_field(score_result_struct.part{part_index}.model,'data.fr_N_tests');
	
	[fr_av_of_attempts, std_of_fr_av_of_attempts, fr_sig_bounds_from_av_of_attempts] = get_best_pract_fr_var(z_scale, fr_hits_vector, fr_N_tests_vector, ext_model_info, included_models, imp_spks_list);
	
	score_result_struct.part{part_index}.parameters.fr_av_of_attempts = fr_av_of_attempts;
	score_result_struct.part{part_index}.parameters.std_of_fr_av_of_attempts = std_of_fr_av_of_attempts;
	score_result_struct.part{part_index}.parameters.fr_sig_bounds_from_av_of_attempts = fr_sig_bounds_from_av_of_attempts;
	
	
	
	% fa, multiple attempts per volunteer, each attempt equal weight
	% according 6.3, Biometric, Testing Best Practices
	% only for cross-evaluation ( n-1 impostors with one client )
	% try to look also for formula for seperate impostor set ...
	
	if (isfield(result_struct,'cross_validation_flag') & (result_struct.cross_validation_flag) & compare_cell_lists(included_models, score_result_struct.model_info.imp_test_spks)),
		
		fa_N_tests_vector = get_nested_field(score_result_struct.part{part_index}.model,'data.fa_N_tests');
		
		
		% reorder fa_hits_infavour_imp_a, labeling of client speakers (in rows) is basis for synchronizing the labeling of impostors (in columns); => element "ii" is zero i.e. no fa hits for self test!
		new_imp_indizes=[];	
		for j=1:length(included_models),
			new_imp_indizes(j) = strmatch(included_models{j}, score_result_struct.model_info.imp_test_spks,'exact');
		end
		
		fa_hits_infavour_imp_array = fa_hits_infavour_imp_array(:,new_imp_indizes);

		[std_of_fa_av_of_attempts, std_of_fa_av_of_attempts_approx, fa_sig_bounds_from_av_of_attempts, fa_av_of_attempts] = get_best_pract_fa_var(z_scale, fa_N_tests_vector, N_imp_spks_per_model, fa_hits_infavour_imp_array, ext_model_info, included_models, imp_spks_list);
		
		
		score_result_struct.part{part_index}.parameters.fa_av_of_attempts = fa_av_of_attempts;
		score_result_struct.part{part_index}.parameters.std_of_fa_av_of_attempts = std_of_fa_av_of_attempts;
		score_result_struct.part{part_index}.parameters.std_of_fa_av_of_attempts_approx = std_of_fa_av_of_attempts_approx;
		score_result_struct.part{part_index}.parameters.fa_sig_bounds_from_av_of_attempts = fa_sig_bounds_from_av_of_attempts;
	
	end
	
