function model_info = ext_model_info_w_HVite_info(model_info, sv_system_name, FA_id)
% model_info = ext_model_info_w_HVite_info(model_info, sv_system_name, FA_id)
%
% CVS_Version_String = '$Id: ext_model_info_w_HVite_info.m,v 1.1 2004/04/16 20:32:49 tuerk Exp $';
% CVS_Name_String = '$Name: rel-1-4-01 $';

% ###########################################################
%
% This file is part of the matlab scripts of the MASV System.
% MASV = Munich Automatic Speaker Verification
%
% Copyright 2002-2003, Ulrich Trk
% Institute of Phonetics and Speech Communication
% University of Munich
% tuerk@phonetik.uni-muenchen.de
%
%
%   MASV is free software; you can redistribute it and/or modify
%   it under the terms of the GNU General Public License as published by
%   the Free Software Foundation; either version 2 of the License, or
%   (at your option) any later version.
%
%   MASV is distributed in the hope that it will be useful,
%   but WITHOUT ANY WARRANTY; without even the implied warranty of
%   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%   GNU General Public License for more details.
%
%   You should have received a copy of the GNU General Public License
%   along with MASV; if not, write to the Free Software
%   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
%
% ###########################################################


	SR_lib;
	

	info_file = [ FA_id 'general_HVite.info' ];

	path_info_file = fullfile(basepath, sv_system_name, 'info');
	info_filename = fullfile(path_info_file, info_file);
	
	try
		line_cell=textread(info_filename,'%s','delimiter','\n','whitespace','');
	catch
		model_info.lab_mlf = '';
		model_info.dict = '';
		model_info.hmm_list = '';
		warning('no general HVite info file found!!');
		return;
	end
	
	if (length(line_cell)>=1),
		model_info.lab_mlf = line_cell{1};
	else
		model_info.lab_mlf = '';
	end
	if (length(line_cell)>=2),
		model_info.dict = line_cell{2};
	else
		model_info.dict = '';
	end
	if (length(line_cell)>=3),
		model_info.hmm_list = line_cell{3};
	else
		model_info.hmm_list = '';
	end
	
	if (length(line_cell) ~= 3),
		warning('general HVite info file has not three entries!!');
	end

