function [fr, fr_coarse, fr_hits, N_tests] = find_FR_coarse(FR_struct_data, threshold,  interpl_flag)
% function [fr, fr_coarse, fr_hits, N_tests] = find_FR_coarse(FR_struct_data, threshold,  interpl_flag)
%
%
% CVS_Version_String = '$Id: find_FR_coarse.m,v 1.7 2004/05/06 13:40:20 tuerk Exp $';
% CVS_Name_String = '$Name: rel-1-4-01 $';

% ###########################################################
%
% This file is part of the matlab scripts of the MASV System.
% MASV = Munich Automatic Speaker Verification
%
% Copyright 2002-2003, Ulrich Trk
% Institute of Phonetics and Speech Communication
% University of Munich
% tuerk@phonetik.uni-muenchen.de
%
%
%   MASV is free software; you can redistribute it and/or modify
%   it under the terms of the GNU General Public License as published by
%   the Free Software Foundation; either version 2 of the License, or
%   (at your option) any later version.
%
%   MASV is distributed in the hope that it will be useful,
%   but WITHOUT ANY WARRANTY; without even the implied warranty of
%   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%   GNU General Public License for more details.
%
%   You should have received a copy of the GNU General Public License
%   along with MASV; if not, write to the Free Software
%   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
%
% ###########################################################



	FR_borders = [ FR_struct_data.borders ];
	N_tests = length(FR_borders);
	
	% order of polyfit
	interpl_order_FR = 2;
	

	% find coarse intersection point
	index_near_FR = max(find((FR_borders - threshold) < 0));
	fr_hits = length(find( FR_borders < threshold ));

	if  isempty(index_near_FR),
		% threshold below left edge of  FR border values
		fr = 0;
		fr_coarse = 0;
		return;
	end

	if (index_near_FR == N_tests)
		% threshold above right edge of FA border values
		fr = 100;
		fr_coarse = 100;
		return;
	end
	

	probabilities_fr = (1:N_tests) / N_tests * 100;
		
	
	fr_coarse = probabilities_fr(index_near_FR);
	
	if (strcmp(interpl_flag, 'no_interpolation')),
		fr = -1;
	else
		if (strcmp(interpl_flag, 'lin_interpolation')),
			index_sub_low = max([1 (index_near_FR) ]);
			index_sub_high = min([N_tests (index_near_FR + 1) ]);
		else
			index_sub_low = max([1 (index_near_FR - 1) ]);
			index_sub_high = min([N_tests (index_near_FR + 2) ]);
		end
		
		sub_FR_borders = FR_borders(index_sub_low:index_sub_high);
		sub_FR_prob = probabilities_fr(index_sub_low:index_sub_high);
		
		% interpolate
		if (strcmp(interpl_flag, 'lin_interpolation')),
			coeff_FR=polyfit(sub_FR_borders,sub_FR_prob,1);
		else
			coeff_FR=polyfit(sub_FR_borders,sub_FR_prob,interpl_order_FR);
		end
		
		% find intersection point, this time with interpolated values
		fr = polyval(coeff_FR,threshold);
		
	end


