function [std_of_fa_av_of_attempts, std_of_fa_av_of_attempts_approx, fa_sig_bounds_from_av_of_attempts, fa_av_of_attempts] = get_best_pract_fa_var(z_scale, fa_N_tests_vector, N_imp_spks_per_model, fa_hits_infavour_imp_a, ext_model_info, models, imp_spks_list)
% function [fr_av_of_attempts, std_of_fr_av_of_attempts, fr_sig_bounds_from_av_of_attempts] 
%          = get_best_pract_fa_var(z_scale, fa_hits_vector, fa_N_tests_vector, 
%            N_imp_spks_per_model, fa_hits_infavour_imp_array, ext_model_info, models, imp_spks_list)
%
% fa, multiple attempts per volunteer, each attempt equal weight
% according 6.3, Biometric, Testing Best Practices
% only for cross-evaluation ( n-1 impostors with one client )
% try to look also for formula for seperate impostor set ...
%
% CVS_Version_String = '$Id: get_best_pract_fa_var.m,v 1.7 2004/05/19 14:26:43 tuerk Exp $';
% CVS_Name_String = '$Name: rel-1-4-01 $';

% ###########################################################
%
% This file is part of the matlab scripts of the MASV System.
% MASV = Munich Automatic Speaker Verification
%
% Copyright 2002-2003, Ulrich Trk
% Institute of Phonetics and Speech Communication
% University of Munich
% tuerk@phonetik.uni-muenchen.de
%
%
%   MASV is free software; you can redistribute it and/or modify
%   it under the terms of the GNU General Public License as published by
%   the Free Software Foundation; either version 2 of the License, or
%   (at your option) any later version.
%
%   MASV is distributed in the hope that it will be useful,
%   but WITHOUT ANY WARRANTY; without even the implied warranty of
%   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%   GNU General Public License for more details.
%
%   You should have received a copy of the GNU General Public License
%   along with MASV; if not, write to the Free Software
%   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
%
% ###########################################################


	if (isequal({'same gender'}, imp_spks_list)),
		result_type = 'same gender';
	else
		result_type = 'normal';
	end
	
	
	
	imp_test_spks = models; % cross comparison condition
	
	[male_indizes, female_indizes]	= get_gender_indizes(models, ext_model_info);
	[male_imp_indizes, female_imp_indizes]	= get_gender_indizes(imp_test_spks, ext_model_info);

	switch (result_type),
		case {'same gender'}

			fa_hits_infavour_imp_a_m = fa_hits_infavour_imp_a(male_indizes, male_imp_indizes);
			fa_hits_infavour_imp_a_f = fa_hits_infavour_imp_a(female_indizes, female_imp_indizes);
			
			[fa_av_m, var_fa_m, var_fa_approx_m] = calc_fa_var(fa_hits_infavour_imp_a_m , fa_N_tests_vector(male_indizes), N_imp_spks_per_model(male_indizes), models(male_indizes), imp_test_spks(male_imp_indizes));
			[fa_av_f, var_fa_f, var_fa_approx_f] = calc_fa_var(fa_hits_infavour_imp_a_f , fa_N_tests_vector(female_indizes), N_imp_spks_per_model(female_indizes), models(female_indizes), imp_test_spks(female_imp_indizes));
		
			weight_m = 0.5;
			weight_f = 0.5;
			
			fa_av = weight_m * fa_av_m + weight_f * fa_av_f;
			var_fa = weight_m^2 * var_fa_m + weight_f^2 * var_fa_f;
			var_fa_approx = weight_m^2 * var_fa_approx_m + weight_f^2 * var_fa_approx_f;
			
			
		otherwise
		
			[fa_av, var_fa, var_fa_approx] = calc_fa_var(fa_hits_infavour_imp_a, fa_N_tests_vector, N_imp_spks_per_model, models, imp_test_spks);
			
	end
	
	std_of_fa_av_of_attempts = sqrt(var_fa) * 100;
	std_of_fa_av_of_attempts_approx = sqrt(var_fa_approx) * 100;
	
	fa_sig_bounds_from_av_of_attempts = [ (fa_av - z_scale * sqrt(var_fa))  (fa_av + z_scale * sqrt(var_fa))] * 100;
	fa_av_of_attempts = fa_av * 100;

return;



	function [fa_av, var_fa, var_fa_approx] = calc_fa_var(fa_hits_infavour_imp_a, fa_N_tests_vector, N_imp_spks_per_model, models, imp_test_spks)
	
		num_of_models = size(fa_hits_infavour_imp_a,1);

		fa_hits_vector = (sum(fa_hits_infavour_imp_a,2))'; % sum over cols (imps) -> fa hits per model; equivalent to c_{j}; j: index of customers		
		
		num_of_samples_per_imp = mean( fa_N_tests_vector ./ N_imp_spks_per_model ); % mean over all clients; equivalent to m
		
		sum_fa_hits = sum(fa_hits_vector);
		observed_fmr = sum_fa_hits / ( num_of_samples_per_imp * num_of_models * (num_of_models - 1 ));
		
		sum_fa_N_tests = sum(fa_N_tests_vector);
		fa_av = sum_fa_hits / sum_fa_N_tests;
		
		% not necessary any more:
		% reorder fa_hits_infavour_imp_a, labeling of client speakers (in rows) is basis for synchronizing the labeling of impostors (in columns); => element "ii" is zero i.e. no fa hits for self test!
		%new_imp_indizes=[];	
		%falsch ??
		%for j=1:size(fa_hits_infavour_imp_a,2),
		%	new_imp_indizes(j) = strmatch(imp_test_spks{j}, models,'exact');
		%end
		%reordered_hits_a = fa_hits_infavour_imp_a(:,new_imp_indizes);
		
		
		fa_hits_infavour_imp = sum(fa_hits_infavour_imp_a,1); % sum over rows (spks) -> fa hits in favour impostor; equivalent to d_{i}; i: index of impostor
		% calc. temp_sum
		temp_sum = sum( sum( fa_hits_infavour_imp_a.^2 + fa_hits_infavour_imp_a .* (fa_hits_infavour_imp_a') ) );
	
	
		
		var_fa = ( (sum( ( fa_hits_vector +  fa_hits_infavour_imp ).^2 ) - (temp_sum)) / ( (num_of_samples_per_imp^2) * num_of_models * (num_of_models - 1) * (num_of_models - 2) * (num_of_models -3)) ) - ( (4*num_of_models - 6) / ((num_of_models-2)*(num_of_models-3)) * observed_fmr^2 );
		
		var_fa_approx = (sum( ( fa_hits_vector +  fa_hits_infavour_imp ).^2 )) / ((num_of_samples_per_imp^2) * num_of_models^2 * (num_of_models -1)^2 ) - 4 / num_of_models * observed_fmr^2 ;
	
	return;
