function [male_indizes, female_indizes]	= get_gender_indizes(model_names_cell, model_info)
% function [male_indizes, female_indizes]	= get_gender_indizes(model_names_cell, model_info)
%
% CVS_Version_String = '$Id: get_gender_indizes.m,v 1.4 2003/12/10 11:13:26 tuerk Exp $';
% CVS_Name_String = '$Name: rel-1-4-01 $';

% ###########################################################
%
% This file is part of the matlab scripts of the MASV System.
% MASV = Munich Automatic Speaker Verification
%
% Copyright 2002-2003, Ulrich Trk
% Institute of Phonetics and Speech Communication
% University of Munich
% tuerk@phonetik.uni-muenchen.de
%
%
%   MASV is free software; you can redistribute it and/or modify
%   it under the terms of the GNU General Public License as published by
%   the Free Software Foundation; either version 2 of the License, or
%   (at your option) any later version.
%
%   MASV is distributed in the hope that it will be useful,
%   but WITHOUT ANY WARRANTY; without even the implied warranty of
%   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%   GNU General Public License for more details.
%
%   You should have received a copy of the GNU General Public License
%   along with MASV; if not, write to the Free Software
%   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
%
% ###########################################################



	%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
	%%%%%%%%%%%%%%%
	spk_struct_array = model_info.spk_struct_array;
	male_vector = zeros(1,length(model_names_cell));
	female_vector = zeros(1,length(model_names_cell));
	for i = 1:length(model_names_cell),
		current_spk = model_names_cell{i};	
		current_sex = spk_struct_array(str2num(current_spk)).sex;
		
		if (strcmp('M',current_sex)),
			male_vector(i) = 1;
		elseif (strcmp('F',current_sex)),
			female_vector(i) = 1;
		end	
		
	end
	male_indizes = find(male_vector == 1);
	female_indizes = find(female_vector == 1);
	%%%%%%%%%%%%%%%%
	%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

