function varargout = get_phonemes_of_model(varargin)
% function [result_string] = get_phonemes_of_model([modelname] or [action, param])
%
% CVS_Version_String = '$Id: get_phonemes_of_model.m,v 1.3 2004/02/10 11:00:22 tuerk Exp $';
% CVS_Name_String = '$Name: rel-1-4-01 $';

% ###########################################################
%
% This file is part of the matlab scripts of the MASV System.
% MASV = Munich Automatic Speaker Verification
%
% Copyright 2002-2003, Ulrich Trk
% Institute of Phonetics and Speech Communication
% University of Munich
% tuerk@phonetik.uni-muenchen.de
%
%
%   MASV is free software; you can redistribute it and/or modify
%   it under the terms of the GNU General Public License as published by
%   the Free Software Foundation; either version 2 of the License, or
%   (at your option) any later version.
%
%   MASV is distributed in the hope that it will be useful,
%   but WITHOUT ANY WARRANTY; without even the implied warranty of
%   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%   GNU General Public License for more details.
%
%   You should have received a copy of the GNU General Public License
%   along with MASV; if not, write to the Free Software
%   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
%
% ###########################################################

	
	if (~exist('mapping_file')),
		global mapping_file;
	end
	if (~exist('mapping_struct')),
		global mapping_struct;
	end
	% default action
	action='convert';

	if (nargin == 2),
		action = varargin{1};
		param = varargin{2};
	elseif (nargin == 1),
		modelname = varargin{1};
	end

	switch action
		case 'convert'
			
			if (isempty(mapping_struct)),
				phonemes_of_model = {'not initialised'};
			else
				phonemes_of_model = {'not found'};
				for i = 1:length(mapping_struct)
					if (strmatch(modelname, mapping_struct{i}.model_name, 'exact'))
						phonemes_of_model = mapping_struct{i}.ph_chain_cell;
						break;
					end
				end
			end
			
			if (nargout == 1),
				varargout{1}=phonemes_of_model;
			end
			
		case 'get_model_names'
			
			if (isempty(mapping_struct)),
				modelnames = {'not initialised'};
			else
				modelnames = {};
				for i = 1:length(mapping_struct)
					modelnames{end+1} = mapping_struct{i}.model_name;
				end
			end
			
			if (nargout == 1),
				varargout{1}=modelnames;
			end
			
	case 'init_mapping'
	
		mapping_file=param;
		
		line_array=textread(mapping_file,'%s','delimiter','\n','whitespace','');
		total_lines = length(line_array);
		
		mapping_struct={};
		
		for line_counter=1:total_lines,
			tmp_line=line_array{line_counter};
			codes=double(tmp_line);
			tab_indizes=find(codes == 9);
			diff_tab_indizes=[ diff(tab_indizes) ];
			follow_ups=find(diff_tab_indizes == 1);
			multitab_indizes=tab_indizes(follow_ups + 1);
			
			tmp_line=remove_vector_items(tmp_line, multitab_indizes);
			codes=double(tmp_line);
			tab_indizes=find(codes == 9);
			
			line_parts={};
			part_start_index=1;
			part_end_index=1;
			for i=1:length(tab_indizes);
				part_end_index = tab_indizes(i) - 1;
				line_parts{end+1}=tmp_line(part_start_index:part_end_index);
				part_start_index= tab_indizes(i) + 1;		
			end
			line_parts{end+1}=tmp_line(part_start_index:end);
			
			model_name=line_parts{1};
			ph_num=str2num(line_parts{2});
			ph_chain=line_parts{3};
			
			quote_indizes=findstr('"',ph_chain);
			if ( (~(iseven(length(quote_indizes)))) | (~(length(quote_indizes) == 2*ph_num ))),
				error(['get_phonemes_of_model: line ' num2str(line_counter) ' has non-matching quotes']);
			end
			
			ph_chain_cell = {};
			for i=1:2:length(quote_indizes),
				ph_chain_cell{end+1} = ph_chain(quote_indizes(i)+1:quote_indizes(i+1)-1);	
			end
			
			
			mapping_struct{end+1}=struct('model_name',model_name,'ph_num', ph_num,'ph_chain_cell',{ph_chain_cell});
			
		end

		
		if (nargout == 1),
			varargout{1}='done';
		end
	end
	
