function fb = lin_fbank(numChans, fftSize, Fs, lopass, hipass)
	
	f_step=Fs/fftSize;
	fn2=floor(fftSize/2);
	
	fb=zeros(numChans, fn2+1);
	
	if ( (lopass == -1) | (lopass < 0)),
		lopass = 0;
	end
	if ( (hipass == -1) | (hipass > Fs/2)),
 		hipass = Fs/2;
	end
	
	
	fr_low=lopass;
	fr_high=hipass;
	fr_f_bandw=(hipass - lopass) / (numChans+1);
	fr_start_vector = fr_low + (0:(numChans+1))*fr_f_bandw;
	
	ind_start_vector=ceil( (fr_start_vector)/f_step) + 1;
	
	filter_i = 1;
	for ind=(ind_start_vector(filter_i):(ind_start_vector(filter_i+1) - 1)),
		fb(filter_i, ind)=triangle_up(((ind-1)*f_step), fr_start_vector(filter_i), fr_f_bandw);
	end

	
	for filter_i=2:numChans,
		for ind=(ind_start_vector(filter_i):(ind_start_vector(filter_i+1) - 1)),
			fb(filter_i, ind)=triangle_up(((ind-1)*f_step), fr_start_vector(filter_i), fr_f_bandw);
			fb(filter_i-1, ind)=1 - triangle_up(((ind-1)*f_step), fr_start_vector(filter_i), fr_f_bandw);
		end
	end

	filter_i=numChans+1;
	for ind=(ind_start_vector(filter_i):(ind_start_vector(filter_i+1) - 1)),
		fb(filter_i-1, ind)=1 - triangle_up(((ind-1)*f_step), fr_start_vector(filter_i), fr_f_bandw);
	end
	
	
return;


	function value=triangle_up( x, start, bandw)
		
		value = ( x - start )  / ( bandw) ;
		
	return;


