%
%
% CVS_Version_String = '$Id: read_snr.m,v 1.2 2003/11/04 10:34:05 tuerk Exp $';
% CVS_Name_String = '$Name: rel-1-4-01 $';

% ###########################################################
%
% This file is part of the matlab scripts of the MASV System.
% MASV = Munich Automatic Speaker Verification
%
% Copyright 2002-2003, Ulrich Trk
% Institute of Phonetics and Speech Communication
% University of Munich
% tuerk@phonetik.uni-muenchen.de
%
% ###########################################################


file = 'calculate_sn_ratio_data_mlf_realized.mlf.txt';

line_array = textread(file,'%s','delimiter','\n','whitespace','');

clear snr_array;

noisy_sessions={'07','14','19','04','10','16'};
fixed_sessions = {'01','03','05','09','12','13','17','07','14','19'};

for i=1:length(line_array),
	line = line_array{i};
	sep_indizes=findstr(line,':')
	slash_indizes=findstr(line,'/')
	temp_struct.spk = line(1:slash_indizes(1)-1);
	temp_struct.ses = line(slash_indizes(1)+1:slash_indizes(2)-1);
	temp_struct.rec = line(slash_indizes(2)+1:sep_indizes(1)-1);
	temp_struct.snr = line(sep_indizes(1)+1:end);
	if isempty(strmatch(temp_struct.ses, noisy_sessions)),
		temp_struct.qn_type = 'quiet';
	else
		temp_struct.qn_type = 'noisy';
	end
	if isempty(strmatch(temp_struct.ses, fixed_sessions)),
		temp_struct.fg_type = 'gsm';
	else
		temp_struct.fg_type = 'fixed';
	end
	snr_array(i)=temp_struct;
end


quiet_indizes=strmatch('quiet',char(snr_array.qn_type));
quiet_snr_vector=str2num(char(snr_array(quiet_indizes).snr));

noisy_indizes=strmatch('noisy',char(snr_array.qn_type));
noisy_snr_vector=str2num(char(snr_array(noisy_indizes).snr));


fixed_indizes=strmatch('fixed',char(snr_array.fg_type));
fixed_snr_vector=str2num(char(snr_array(fixed_indizes).snr));

gsm_indizes=strmatch('gsm',char(snr_array.fg_type));
gsm_snr_vector=str2num(char(snr_array(gsm_indizes).snr));


