#!/usr/bin/perl


# #####################################################
#
# This file is part of the Perl scripts of the MASV System.
# MASV = Munich Automatic Speaker Verification
#
# Copyright 2002-2003, Ulrich Trk
# Institute of Phonetics and Speech Communication
# University of Munich
# tuerk@phonetik.uni-muenchen.de
#
#
#   MASV is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.
#
#   MASV is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with MASV; if not, write to the Free Software
#   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# #####################################################

my $CVS_Version_String = '$Id: loop_thru_speakersets.pl,v 1.9 2004/03/07 10:52:58 tuerk Exp $';
my $CVS_Name_String = '$Name: rel-1-4-01 $';


use lib $ENV{"MASV_PERL_ROOT"};

use SR_lib;
use strict;

use File::Copy;
use File::Path;
use Cwd;
use Getopt::Long qw( GetOptions );
use Pod::Usage;

my $exit_state = 0;

###########################
# Default values for options
my $help = 0;
my $Identify = 0;

###########################
# Processing Options

# flat
GetOptions('help|?' => \$help,
		   'version' => \$Identify);

if ($Identify) {
	printf "$0\n$CVS_Version_String\n$CVS_Name_String\n\n"; 
}

if ((@ARGV != 3) || ($help)) {
   pod2usage(1);
   exit 1;
 }

my $script_name = $ARGV[0];
my $speakerset_list = $ARGV[1];
my $sv_system_name = $ARGV[2];


my $sv_system_path = "${SR_lib::sv_systems_dir}${sv_system_name}$SR_lib::sign";
my $speakerset_list_path = "${sv_system_path}speaker_set_lists${SR_lib::sign}";


my $bash_binary = `which bash`;
chomp($bash_binary);

unless (open(FILE, "${speakerset_list_path}$speakerset_list") ) {
	die "speaker set list   $speakerset_list  not found!\n\n";
}
my @speakerset_list_entries = <FILE>;
close FILE;



foreach my $current_speakerset (@speakerset_list_entries) {
	chomp($current_speakerset);
	$exit_state += system("switch_MASV_spk_data_set.pl $sv_system_name $current_speakerset");

	my $current_ss_base = $current_speakerset;
	$current_ss_base =~ s/.*\///; # only basename without path
	&SR_lib::change_matlab_calc_script($script_name, "_${current_ss_base}");
	
	print STDERR "=====================================\n";
	print STDERR "New speaker set: $current_speakerset \n\n";
	$exit_state += system("$bash_binary $script_name"); 
}
# reset matlab startup file
&SR_lib::change_matlab_calc_script($script_name, "");

print STDERR "=====================================\n";
print STDERR "Finished loop thru speaker sets. \n\n";


exit $exit_state;




__END__

=head1 NAME

loop_thru_speakersets.pl  - repeat a script for different speaker sets

=head1 SYNOPSIS

loop_thru_speakersets.pl [options] script_name  speakerset_list  sv_system_name

Repeat a shell script for the given speaker sets. The speaker sets
are listed in a file (speakerset_list), one entry per line. The speaker sets
themselves are defined in the SV system directory "speaker_sets/".
This tool is useful to evaluate the statistical dependency of the performance 
of a SV system on different speaker sets (a kind of bootstrap analysis).

 Options:

 -version                 print version information.

 -? | help                display this message.
 
=cut

