function [prompt_string, realized_string] = read_label_file( subject, session, recording)
% function [prompt_string, realized_string] = read_label_file( subject, session, recording)
%
% CVS_Version_String = '$Id: read_label_file.m,v 1.1 2004/02/16 10:09:48 tuerk Exp $';
% CVS_Name_String = '$Name: rel-1-3 $';

% ###########################################################
%
% This file is part of the matlab scripts of the MASV System.
% MASV = Munich Automatic Speaker Verification
%
% Copyright 2002-2003, Ulrich Trk
% Institute of Phonetics and Speech Communication
% University of Munich
% tuerk@phonetik.uni-muenchen.de
%
%
%   MASV is free software; you can redistribute it and/or modify
%   it under the terms of the GNU General Public License as published by
%   the Free Software Foundation; either version 2 of the License, or
%   (at your option) any later version.
%
%   MASV is distributed in the hope that it will be useful,
%   but WITHOUT ANY WARRANTY; without even the implied warranty of
%   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%   GNU General Public License for more details.
%
%   You should have received a copy of the GNU General Public License
%   along with MASV; if not, write to the Free Software
%   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
%
% ###########################################################



	SR_lib;

	full_name = fullfile(rawdatapath, subject, session, recording);
	
	fid = fopen(full_name,'r');
	if (fid == -1)
		prompt_string = 'not available';
		realized_string = 'not available';
		return;
	end
	fclose(fid);

	line_array=textread(full_name,'%s','delimiter','\n','whitespace','');

	line_counter = length(line_array);

	LBR_indizes = strmatch('LBR:', line_array);
	LBO_indizes = strmatch('LBO:', line_array);

	if ~(length(LBR_indizes) == 1)
		error(['More than one label line in label file ' full_name]);
	end
	if ~(length(LBR_indizes) == length(LBO_indizes))
		error(['read_label_file: label file ' full_name ' is not well formed!']);
	end
	
	lbr_line = line_array{LBR_indizes};
	lbo_line = line_array{LBO_indizes};
	
	comma_borders = findstr(lbr_line, ',');
	% ASCII code 13 am Ende der Zeile weglassen
	prompt_string = lbr_line(comma_borders(end)+1:end-1); 

	comma_borders = findstr(lbo_line, ',');
	realized_string = lbo_line(comma_borders(end)+1:end-1);
		
	if ~(isempty(strmatch('EXT:',line_array{LBO_indizes+1})))
		realized_string = [realized_string line_array{LBO_indizes+1}(5:end-1)];
	end
