
  # script to analyse before after acoustical/phonological data of a single ABM
  # relevant data for this script are:
  # res2.df : protocol of memory contents 
  #           (column 'Cond' indicates data before ABM as 'orig', otherwise the sG number
  # sG : SimGroup after which the plots should be made (e.g. '20') 
  # plotSpeaker : if not "", filter plots to this agent, if applicable 
  # plotOnlySibilant : if not "", filter plots to this sibilant (Initial), if applicable
  # phonClusterLog.names : label names
  # strongColors/fadedcolors : order of colors in phonClusterLog.names
  # generalLegend : label key
  # runInteractive : if set to F, the script runs silent
    
  cat("\nRunning script 'beforeAfterABMPlots'\n\n") 

  # for some plots filter protocol to one speaker
  if(plotSpeaker != "") {
    o.plot = res2.df[res2.df$Vpn==plotSpeaker&res2.df$Cond=="orig",]
    o1.plot = res2.df[res2.df$Vpn==plotSpeaker&res2.df$Cond==sG,]
  } else {
    o.plot = res2.df[res2.df$Cond=="orig",]
    o1.plot = res2.df[res2.df$Cond==sG,]
  }
  # for plotting filter current memory tokens to a single sibilant class (Initial)
  if(plotOnlySibilant != "") {
    o.plot = o.plot[o.plot$Initial==plotOnlySibilant,]
    o1.plot = o1.plot[o1.plot$Initial==plotOnlySibilant,]
  }

  # color grouping according canonical labels
  colorGroupVectorOrig = factor(o.plot$Initial,levels=phonClusterLog.names)
  colorGroupVector = factor(o1.plot$Initial,levels=phonClusterLog.names)

  # make before/after plot of DCT0/2 plane with elipsei for selected speaker
  xyOverlayOrig02 = xyplot(P3 ~ P1|o.plot$Vpn,group=colorGroupVectorOrig,type='p',col=fadedColors,data=o.plot,main="M1 DCT-0 vs. DCT-2, before (faded) and after ABM, canonical labels",xlab=xname,ylab=zname,xlim=xlim,ylim=zlim,key=generalLegend,panel = function(x, y, ...) {
           panel.xyplot(x, y, ...)
           panel.ellipse(x, y, ...)
       })
  xyOverlay02 = xyplot(P3 ~ P1|o1.plot$Vpn,group=colorGroupVector,type='p',col=strongColors,data=o1.plot,xlim=xlim,ylim=zlim,panel = function(x, y, ...) {
           panel.xyplot(x, y, ...)
           panel.ellipse(x, y, ...)
       })
  if(printPaperFigs) {
    pdf(paste(LogDirDate,"DCT0-2BeforeAfter.pdf",sep="/"))
    print(xyOverlayOrig02+ xyOverlay02)
    dev.off()
  }
  if(runInteractive) {
    print(xyOverlayOrig02+ xyOverlay02)
    inpu = readline("Plot distribution of canonical label before and after ABM ok? Continue? (Y/n) ")
    if(inpu != "" && inpu != "Y" && inpu != "y") {
      cat("Script stopped by user\n")
      stop()
    }
  }
  ######
  # STOP
  ######

  # make before/after pie chart of equivalence phone cluster distribution over all speakers
  # pie before
  temp = res2.df$Cond=="orig"
  res2.orig = res2.df[temp,]
  eclassLabels = as.character(res2.orig$V)
  for(spkr in unique(res2.orig$Vpn)){
    temp = res2.orig$Vpn == spkr
    eclassLabels[temp] = equal_class(as.character(res2.orig$Initial[temp]), as.character(res2.orig$V[temp]))
  }
  tab.orig = table(eclassLabels)
  col.orig = strongColors[phonClusterLog.names %in% names(tab.orig)]
  temp = res2.df$Cond==sG
  res2.abm = res2.df[temp,]
  eclassLabels = as.character(res2.abm$V)
  for(spkr in unique(res2.abm$Vpn)){
    temp = res2.abm$Vpn == spkr
    eclassLabels[temp] = equal_class(as.character(res2.abm$Initial[temp]), as.character(res2.abm$V[temp]))
  }
  tab.abm = table(eclassLabels)
  col.abm = strongColors[phonClusterLog.names %in% names(tab.abm)]
  # 2 pie charts on one sheet
  if(runInteractive) {
    par(mfrow=c(1,2))
    pie(tab.orig, names(tab.orig),main="Equivalence Classes before ABM",col=col.orig)
    pie(tab.abm, names(tab.abm),main="Equivalence Phone Classes after ABM",col=col.abm)
    par(mfrow=c(1,1))
    inpu = readline("Pie chart equivalence phone clusters before/after ABM ok? Continue? (Y/n) ")
    if(inpu != "" && inpu != "Y" && inpu != "y") {
      cat("Script stopped by user\n")
      stop()
    }
  }
  if(printPaperFigs) {
    pdf(paste(LogDirDate,"equivPhonClusterPieBeforeAfter.pdf",sep="/"))
    par(mfrow=c(1,2))
    pie(tab.orig, names(tab.orig),main="Equivalence Classes before ABM",col=col.orig)
    pie(tab.abm, names(tab.abm),main="Equivalence Classes after ABM",col=col.abm)
    par(mfrow=c(1,1))
    dev.off()
  }
  
  # make before (solid) and after (dashed) ABM plot group-level averaged M1 tracks
  # aggregate DCTs by sibilant initials (averaged over agents!) for start and end ABM
  res2.before.after = res2.df[res2.df$Cond=='orig'|res2.df$Cond==sG,]
  res2.agg = aggregate(cbind(P1,P2,P3) ~ Initial + Cond,mean,data=res2.before.after)
  # add dummy Age, V, Vpn and W columns because build_dct_df.sibilant() needs one
  Age = rep(1,times=length(res2.agg$Initial))
  res2.agg = data.frame(res2.agg,Vpn=Age,V=Age,Age=Age,W=Age)
  # calculate (smoothed) M1 tracks from the DCT values
  dctTracks.df = build_dct_df.sibilant(res2.agg)
  # rename "orig" in Cond as 0
  cnd = as.character(dctTracks.df$Cond)
  cnd[cnd=="orig"] = "0"
  cnd = as.numeric(cnd)
  dctTracks.df$Cond = cnd
  # rename F2Pop as M1smooth
  names(dctTracks.df)[1] = "M1smooth"
  # plot orig data
  # group = Initial works here because we have only one track per Vpn and per Initial!
  # /S/ : blue, /s/ : red, /str/ : green
  ylim=c(-2.5,2.5)
  plot.orig = xyplot(M1smooth ~ times, group = Initial, type = c("l", "g"), data=dctTracks.df[dctTracks.df$Cond==0,],ylim=ylim,col=strongColors[c(1,5,7)],lty=1,main="Group-level averaged M1 tracks before (solid) / after (dashed) ABM, canonical labels")
  # plot of same tracks after plotSimGroup * simGroupSize interactions
  plot.end = xyplot(M1smooth ~ times, group = Initial, type = c("l", "g"), data=dctTracks.df[dctTracks.df$Cond==sG,],ylim=ylim,col=strongColors[c(1,5,7)],lty=2)
  if(printPaperFigs) {
    pdf(paste(LogDirDate,"AverageTracks.pdf",sep="/"))
    print(plot.orig + plot.end)
    dev.off()
  }
  if(runInteractive) {
    print(plot.orig + plot.end)
    inpu = readline("Plot averaged M1 tracks before (solid) and after (dashed) ABM ok? Continue? (Y/n) ")
    if(inpu != "" && inpu != "Y" && inpu != "y") {
      cat("Script stopped by user\n")
      stop()
    }
  }
    ######
    # STOP
    ######

