#
# generates artificial agent set for DemoABM
#
#
#  F. Schiel 2017-04-03
#

# helper script to create the artificial distributions needed in 
# DemoABM  

############################################################
# CHANGE THIS IF YOU MOVE THE EXPERIMENT TO ANOTHER COMPUTER
# to the installation dir of the package (where you see 'Rcmd') 
pfad2 = "/homes/schiel/ABM/DemoABM.1"
############################################################


source("Rcmd/pathsAndLibraries.R")



# parameters
groupSize = 10                               # number of agents in each group
memorySize = 50                              # tokens per segment /x/
narrowSigma = 2500                           # sigma (= SD^2) of the narrow SD; approx. 50Hz
middleSigma = 22500                          # sigma (= SD^2) of the narrow SD; approx. 150Hz
broadSigma = 62500                           # sigma (= SD^2) of the wide SD; approx. 250Hz
meanA = c(500,1500)                          
meanB = c(1200,1500)

# plot dimensions so that both dimensions have the same resolution
xlim = c(0,2000)
ylim = c(500,2500)

# first we create a str.df dataframe with bogus information for the 7 groups
nLines = 7 * groupSize * memorySize
nGroup = groupSize * memorySize
Speaker = paste("S",rep(1:(groupSize*7),each=memorySize),sep="")
str.df = data.frame(labels=rep("x",times=nLines), Word=rep("W",times=nLines), Speaker, Initial=rep("x",times=nLines), M1=rep(0,times=nLines), P1=rep(0,times=nLines), P2=rep(0,times=nLines), Gender=c(rep("A1",times=nGroup),rep("A2",times=nGroup),rep("B1",times=nGroup),rep("B2",times=nGroup),rep("C",times=nGroup),rep("D",times=nGroup),rep("E",times=nGroup))) 

# fill group A1 with samples
covvar = matrix(c(narrowSigma,0,0,narrowSigma), nrow = 2, ncol = 2, byrow = TRUE)
pData = mvrnorm(n=nGroup,mu=meanA,covvar)
str.df$P1[str.df$Gender=="A1"] = pData[,1]
str.df$P2[str.df$Gender=="A1"] = pData[,2]
# check
# xyplot(P2 ~ P1,group=Gender,type='p',data=str.df[str.df$Gender=="A1",],panel = function(x, y, ...) { panel.xyplot(x, y, ...); panel.ellipse(x, y, ...) },auto.key=T,xlim=xlim,ylim=ylim)

# fill group A2 with samples
covvar = matrix(c(middleSigma,0,0,middleSigma), nrow = 2, ncol = 2, byrow = TRUE)
pData = mvrnorm(n=nGroup,mu=meanA,covvar)
str.df$P1[str.df$Gender=="A2"] = pData[,1]
str.df$P2[str.df$Gender=="A2"] = pData[,2]
# check
print(xyplot(P2 ~ P1,group=Gender,type='p',data=str.df[str.df$Gender=="A1"|str.df$Gender=="A2",],panel = function(x, y, ...) { panel.xyplot(x, y, ...); panel.ellipse(x, y, ...) },auto.key=T,xlim=xlim,ylim=ylim))
inpu = readline("Distributions A1 and A2. Continue? (Y/n)  ")

# fill group B1 with samples: largest distribution oriented towards A mean
covvar = matrix(c(broadSigma,0,0,narrowSigma), nrow = 2, ncol = 2, byrow = TRUE)
pData = mvrnorm(n=nGroup,mu=meanB,covvar)
str.df$P1[str.df$Gender=="B1"] = pData[,1]
str.df$P2[str.df$Gender=="B1"] = pData[,2]
# check
print(xyplot(P2 ~ P1,group=Gender,type='p',data=str.df[str.df$Gender=="A1"|str.df$Gender=="B1",],panel = function(x, y, ...) { panel.xyplot(x, y, ...); panel.ellipse(x, y, ...) },auto.key=T,xlim=xlim,ylim=ylim))
inpu = readline("Distributions A1 and B1. Continue? (Y/n)  ")

# fill group B2 with samples: largest distribution oriented 90 degrees to A mean
covvar = matrix(c(narrowSigma,0,0,broadSigma), nrow = 2, ncol = 2, byrow = TRUE)
pData = mvrnorm(n=nGroup,mu=meanB,covvar)
str.df$P1[str.df$Gender=="B2"] = pData[,1]
str.df$P2[str.df$Gender=="B2"] = pData[,2]
# check
print(xyplot(P2 ~ P1,group=Gender,type='p',data=str.df[str.df$Gender=="A1"|str.df$Gender=="B2",],panel = function(x, y, ...) { panel.xyplot(x, y, ...); panel.ellipse(x, y, ...) },auto.key=T,xlim=xlim,ylim=ylim))
inpu = readline("Distributions A1 and B2. Continue? (Y/n)  ")

# fill group C with samples: large SD in B but no orientation towards A mean
covvar = matrix(c(middleSigma,0,0,middleSigma), nrow = 2, ncol = 2, byrow = TRUE)
pData = mvrnorm(n=nGroup,mu=meanB,covvar)
str.df$P1[str.df$Gender=="C"] = pData[,1]
str.df$P2[str.df$Gender=="C"] = pData[,2]
# check
print(xyplot(P2 ~ P1,group=Gender,type='p',data=str.df[str.df$Gender=="A1"|str.df$Gender=="C",],panel = function(x, y, ...) { panel.xyplot(x, y, ...); panel.ellipse(x, y, ...) },auto.key=T,xlim=xlim,ylim=ylim))
inpu = readline("Distributions A1 and C. Continue? (Y/n)  ")

# fill group D with samples
# this is tricky: we want the individual distributions to be small circular but the overall SD should be the 
# size of broadSigma
covvar = matrix(c(narrowSigma,0,0,narrowSigma), nrow = 2, ncol = 2, byrow = TRUE)
# split the full circle into groupSize segments and place the mean of each agent in one segment with an 
# empirical estimated distance from meanB so that the overall SD is about broadSigma
distFromMeanB = 347
segM = 2*pi/groupSize
# go over agents of group D
for(angleC in 1:groupSize) {
  meanX = distFromMeanB * cos(angleC * segM) 
  meanY = distFromMeanB * sin(angleC * segM) 
  pData = mvrnorm(n=memorySize,mu=meanB+c(meanX,meanY),covvar)
  Speaker = paste("S",(5*groupSize)+angleC,sep="")
  str.df$P1[str.df$Gender=="D"&str.df$Speaker==Speaker] = pData[,1]
  str.df$P2[str.df$Gender=="D"&str.df$Speaker==Speaker] = pData[,2]
}
# check
# sd(str.df$P1[str.df$Gender=="D"])^2
print(xyplot(P2 ~ P1,group=Gender,type='p',data=str.df[str.df$Gender=="A1"|str.df$Gender=="D",],panel = function(x, y, ...) { panel.xyplot(x, y, ...); panel.ellipse(x, y, ...) },auto.key=T,xlim=xlim,ylim=ylim))
inpu = readline("Distributions A1 and D. Continue? (Y/n)  ")

# fill group E with samples
# this is tricky: we want the individual distributions to be small circular but the overall SD should be the 
# size and form (oriented towards A1) of B1. We do that by generating 10 A1 like distributions but shift their 
# mean on a line  
covvar = matrix(c(narrowSigma,0,0,narrowSigma), nrow = 2, ncol = 2, byrow = TRUE)
# go over agents of group E
for(shiftX in 1:groupSize) {
  meanDist = 70 # distance of individual means of agents in X
  pData = mvrnorm(n=memorySize,mu=meanB+c((shiftX-6)*meanDist,0),covvar)
  Speaker = paste("S",(6*groupSize)+shiftX,sep="")
  str.df$P1[str.df$Gender=="E"&str.df$Speaker==Speaker] = pData[,1]
  str.df$P2[str.df$Gender=="E"&str.df$Speaker==Speaker] = pData[,2]
}
# check
# sd(str.df$P1[str.df$Gender=="D"])^2
print(xyplot(P2 ~ P1,group=Gender,type='p',data=str.df[str.df$Gender=="A1"|str.df$Gender=="E",],panel = function(x, y, ...) { panel.xyplot(x, y, ...); panel.ellipse(x, y, ...) },auto.key=T,xlim=xlim,ylim=ylim))
inpu = readline("Distributions A1 and E. Continue? (Y/n)  ")



# write fake str.df to data
write.table(str.df,"data/str.df")

# now start Rcmd/master.R

