#
# This R snippet loads pre-calculated differences in the SD of the
# feature DCT-0 of the M1 tracks (=the main distinguishing feature 
# between /s / and /S/) after - before the ABM run with Split&Merge.
# Each result pair represents one individual ABM simulation (20.000 interactions).
# The differences are first calculated for each speaker and then 
# averaged over all speakers from the M1 track sets stored in agents' menories..
# Basically these numbers express, how in a certain ABM (line in table) the 
# distribution of iDCT-0 in /str/ tokens and non-/str/ tokens change over the course
# of the ABM: if the value is positiv, the distribution expanded, if negative 
# the distribution compressed.
# But in most ABM runs we observe that the change of SD after - before ABM is 
# larger for /str/ tokens than for non-/str/ tokens.
# Or with other words, that the /str/ tokens are becoming more ambigue during the 
# ABM than the /s/ and /S/ tokens.

############################################################
# CHANGE THIS IF YOU MOVE THE EXPERIMENT TO ANOTHER COMPUTER
# the master dir where this script resides (in subdir Rcmd)
pfad2="/homes/schiel/ABM/SibilantsAustralianEnglish2016"
############################################################


# load a two-column table with average DCT-0 SD differences after-before ABMs with Split&Merge
# 1st col : changes in /str/ tokens, 2nd column: changes in non-/str/ tokens
sdChange = read.table(paste(pfad2,"sdChangeMah2.5.txt",sep="/"),colClasses="numeric",header=T)

boxplot(sdChange$strSDChange,sdChange$sSSDChange,names=c("/str/ tokens","/s/ and /S/ tokens"),main="Change of M1 SD during ABM")

t.test(sdChange$strSDChange,sdChange$sSSDChange,paired=T)
