equal_class = function(original, derived)
{
    # original: a canonical underlying set of labels
    # derived: derived labels from splitting and merging
    # outputs: the corresponding equivalence classes in terms of all possible permutations of the phonemes in original (e.g. if the phonemes are /A, B, C/ then the output is any of /A, B, C, A+B, A+C, B+C, A+B+C/
tab = t(table(original, derived))
# names of derived
nam.d = rownames(tab)
# names of original
nam.o = colnames(tab)

# create a matrix of logical F with same dimension as tab
bintab = matrix(F, nrow=nrow(tab), ncol=ncol(tab))
for(j in 1:ncol(tab)){
    # 0 becomes F and any other value becomes T
    bintab[,j] = tab[,j]!=0
    }

# now replace the derived labels with equivalence classes
for(j in 1:nrow(bintab)){
    lab.equivalent = paste(nam.o[bintab[j,]], collapse="+")
    # replace derived with lab.equivalent
    derived[derived==nam.d[j]] = lab.equivalent
    
}

derived
}


