#!/bin/perl
#
# generateTxt.pl PROMPTFILE SESSIONDIR
# 
# generates for each WAV-file in a recording session diretory a TXT file with
# the prompt text; WAV and TXT files are matched via the speaker code, session number and
# itemcode, e.g. CHDR0000X1.WAV and CHDR0000X1.TXT

$promptFile = $ARGV[0];
$sessionDir = $ARGV[1];

open(PROMPT, $promptFile) or die $!;
while(<PROMPT>) {
	chomp;
	(my $code, my $type, my $instructions, my $text, my $normalized) = split(/\t/);
	if ($type eq 'read') {
		$prompt{$code} = $normalized;
	}
}
close(PROMPT);

opendir(DIR, $sessionDir) or die $!;
while(my $wavFile = readdir(DIR)) {
	
	if ($wavFile =~ m/^(.*)([0-9]{4})(.*)\.wav$/) {
		
		(my $spkCode, my $sessionNo, my $itemCode) = ($1, $2, $3);
		
		if ($prompt{$itemCode}) {
			
			my $textFile = $wavFile;
			$textFile =~ s/.wav/.txt/;
			
			my $outputFile = $sessionDir . $textFile;
			open(FILE, ">$outputFile") or die $!;
			
			printf FILE "%s\n", $prompt{$itemCode};
			
			close(FILE);
		}
	}
}
closedir(DIR);

exit(0);
