#!/bin/perl
#
# unifySessions appends a SpeechRecorder project directory
# to a SpeechRecorder directory with the same name
# in the target directory and automatically a) renames 
# all recording sessions and b) extends the speaker file
# in the target directory

use File::Copy;

my $project = $ARGV[0];
my $source = $ARGV[1];
my $target = $ARGV[2];

my $RECDIR = 'RECS';
my $SPKFILE = $project . '_speakers.txt';

my $targetProject = $target . '/' . $project . '/';
my $targetRecDir = $targetProject . $RECDIR;

# get highest recording session number in the target directory
my $maxSessionNo = 0;

if (!-e $target) {
	mkdir($target);
}

if (!-e $targetProject) {
	mkdir($targetProject);
}

if (!-e $targetRecDir) {
	mkdir($targetRecDir);
}


opendir (DIR, $targetRecDir) or die $!;
my @sessionDirs = readdir DIR;
closedir DIR;

foreach my $session (@sessionDirs) {
	
	# skip to next entry if the session begins with a '.'
	next if ($session =~ m/^\./);
	
	printf "%s\n", $session;
	
	if($session =~ /([0-9]{4})/) {
		$session = $session + 0;
		if ($session > $maxSessionNo) {
			$maxSessionNo = $session;
		}
	}
}

printf "Maximum session number: $maxSessionNo\n";

# now read all recording directories from the source directory,
# generate the new session number, and
# rename the recording directories and the audio files accordingly

my $sourceProject = $source . '/' . $project . '/';
my $sourceRecDir = $sourceProject . $RECDIR;

opendir (SRC, $sourceRecDir) or die $!;
my @sourceDirs = readdir SRC;
closedir SRC;

foreach my $sourceSession (@sourceDirs) {

	#printf "%s\n", $sourceSession;
	
	# skip to next entry if the session begins with a '.'
	next if ($sourceSession =~ m/^\./);
	
	if ($sourceSession =~ /[0-9]{4}/) {
		$newSessionNo = $maxSessionNo + 1;
		$newSessionDirNo = '000' . $newSessionNo;
		$newSessionDirNo = substr($newSessionDirNo, -4);
		$newSessionDir = $targetProject . '/' . $RECDIR . '/' . $newSessionDirNo;
		
		if (! -e $newSessionDir) {
			mkdir $newSessionDir;
		}
		
		# now copy all recording files and rename them
		opendir (REC, $sourceRecDir . '/' . $sourceSession) or die $!;
		while(my $file = readdir(REC)) {
			if ($file =~ /^.*\.wav/) {
				my $baseFile = $file;
				$baseFile =~ s#^./##;
				
				#printf "%s\n", $baseFile;
				
				my $speaker = $baseFile;
				$speaker =~ s/(.*)[0-9]{4}.*\.wav/\1/;
				
				my $oldSession = $baseFile;
				$oldSession =~ s/.*([0-9]{4}).*/\1/;
				
				my $itemCode = $baseFile;
				$itemCode =~ s/.*[0-9]{4}(.*)\.wav/\1/;
				
				my $oldFileName = $sourceRecDir . '/' . $sourceSession . '/' . $file;
				my $newFileName = $newSessionDir . '/' . $speaker . $newSessionDirNo . $itemCode . '.wav';
				
				#printf "%s -> %s\n", $sourceRecDir . '/' . $sourceSession . '/' . $file, $newFileName;
				copy($oldFileName, $newFileName) or die "Copy failed: $!";
			} 
		}
		closedir REC;
	}
}

# now append the source directory speaker table to the target directory speaker table
# first, get the largest speaker index in the new speaker file
my $maxSpkNo = -1;
my %speakers = {};
if (-e $targetProject . $SPKFILE) {
	open(NEWSPK, $targetProject . $SPKFILE) or die $!;
	while(<NEWSPK>) {
		chomp;
		(my $spkNo, my $spkCode, my $spkName, my $spkFirstname, my $spkSex, my $spkAccent, my $spkBirthday) = split(/\t/);
		my $spkData = $spkNo . '\t' . $spkCode . '\t' . $spkName . '\t' .$spkFirstname . '\t' .$spkSex . '\t' .$spkAccent . '\t' .$spkBirthday;
		$speakers{$spkCode} = $spkData;
		if ($spkNo > $maxSpkNo) {
			$maxSpkNo = $spkNo;
		}
	}
	close(NEWSPK);
}

open(OLDSPK, $sourceProject . $SPKFILE) or die $!;
open(NEWSPK, '>>' . $targetProject . $SPKFILE) or die $!;

my $newSpkNo = $maxSpkNo;
while(<OLDSPK>) {
	chomp;
	# sample line
	#1	CHDR	Draxler	Christoph	M	DE-NI	12-1960
	(my $spkNo, my $spkCode, my $spkName, my $spkFirstname, my $spkSex, my $spkAccent, my $spkBirthday) = split(/\t/);
	$newSpkNo = $newSpkNo + 1;
	
	# check for duplicate speaker codes
	my $spkData = $spkNo . '\t' . $spkCode . '\t' . $spkName . '\t' .$spkFirstname . '\t' .$spkSex . '\t' .$spkAccent . '\t' .$spkBirthday;
	if ($speakers{$spkCode}) {
		printf "WARNING! Check for duplicate speakers: %s (%s) and (%s)\n", $spkCode, $speakers{$spkCode}, $spkData;
	} 
	$speakers{$spkCode} = $spkData;
	
	printf NEWSPK "%d\t%s\t%s\t%s\t%s\t%s\t%s\n", $newSpkNo, $spkCode, $spkName, $spkFirstname, $spkSex, $spkAccent, $spkBirthday;
}
close(OLDSPK);
close(NEWSPK);	

exit(0);