%do_calcpos4mat
%run calcpos, then convert pos files (and posamps) to mat

clear variables

triallist=185:195;
%basepath should normally be the path used for raw output from filteramps,
%leaving out the final '/amps/'
mysuff='';
outpathraw=['ampsfilt' mysuff 'raw' filesep 'amps' filesep]; %copied from do_filteramps
basepath=outpathraw;
basepath=strrep(basepath,[filesep 'amps' filesep],'');

rawpospath=[basepath filesep 'rawpos'];

calcpospath='/raid/tera21/Phil/calcpostst/age/bin';	%location of calcpos executable
[statusb,resultc]=calcpos4mat(calcpospath,basepath,triallist);

%plot(1:max(triallist),statusb);
%xlabel('Trial');
%title('Calcpos status (should be zero)');

load([outpathraw 'info']);	%should contain sensornames, samplerate, comment
posampflag=1;
matpath=[basepath 'rawposmat'];
mkdir(matpath);
rawpos2mat(rawpospath,matpath,triallist,samplerate,comment,sensornames,posampflag)

vv=find(statusb);
if ~isempty(vv)
	disp('Calcpos error for following trials (see resultc for details');
	disp(vv');
end;
