## ---- rexample:webApp_serve, rexample=TRUE, eval=FALSE-------------------
## # serve ae emuDB to EMU-webApp
## serve(ae)

## ---- rexample:webApp_loadDemoData, rexample=TRUE, results='hide', message=FALSE----
# load package
library(emuR)

# create demo data in directory provided by tempdir()
create_emuRdemoData(dir = tempdir())

# create path to demo database
path2ae = file.path(tempdir(), "emuR_demoData", "ae_emuDB")

# load database
ae = load_emuDB(path2ae, verbose = F)

## ---- rexample:webApp_listPersp, rexample=TRUE---------------------------
# list perspectives of ae emuDB
list_perspectives(ae)

## ---- rexample:webApp_addRemovePersp, rexample=TRUE----------------------
# add new perspective to ae emuDB
add_perspective(ae,
                name = "tmpPersp")

# show added perspective
list_perspectives(ae)

# remove newly added perspective
remove_perspective(ae,
                   name = "tmpPersp")

## ---- rexample:webApp_oders, rexample=TRUE-------------------------------
# get order vector of signal canvases of default perspective
sco = get_signalCanvasesOrder(ae,
                              perspectiveName = "default")

# show sco vector
sco

# reverse sco order
# using R's rev() function
scor = rev(sco)

# set order vector of signal canvases of default perspective
set_signalCanvasesOrder(ae,
                        perspectiveName = "default",
                        order = scor)

# set order vector of level canvases of default perspective
# to only display the "Tone" level
set_levelCanvasesOrder(ae,
                       perspectiveName = "default",
                       order = c("Tone"))

# list perspectives of ae emuDB
# to show changes
list_perspectives(ae)

## ---- rexample:webApp_badLevelOrders, rexample=TRUE, error=TRUE----------
# set level canvas order where a
# level is passed into the order parameter
# that is not of type EVENT or SEGMENT
set_levelCanvasesOrder(ae,
                       perspectiveName = "default",
                       order = c("Syllable"))

## ---- rexample:webApp_addFormantsToSignalCanvases, rexample=TRUE---------
# show currently available SSFF tracks
list_ssffTrackDefinitions(ae)

# re-set order vector of signal canvases of default perspective
# by appending the fm track
set_signalCanvasesOrder(ae,
                        perspectiveName = "default",
                        order = c(scor, "fm"))

## ---- echo=FALSE, results='hide', message=FALSE--------------------------
# clean up emuR_demoData
unlink(file.path(tempdir(), "emuR_demoData"), recursive = TRUE)

