template<-"eggneu"
segs<-emu.query(template,"*", "[[phonetic=e:|e ^ [Word= Lena|Lenor & Accent !=A]] ^ [Utterance!=etwas & Speaker !=DP]]") 
    l.accent <- emu.requery(segs, "phonetic", "Accent", justlabels=T)
    sy1 <- emu.requery(segs, "phonetic", "Syllable")
    l.stress<-label(sy1)
    l.vol <- emu.requery(segs, "phonetic", "Utterance", justlabels=T)
    koms <- paste(substring(l.vol,1,1),substring(l.accent,1,1), substring(l.stress,1,1), sep=".")
    
    midvowel<-emu.requery(segs, "phonetic", "midvowel")

    form<-emu.track(segs, "fm")
    formmid<-dcut(form, mustart(midvowel))
    vp<-as.factor(substring(utt(segs),1,2))

    bw<-emu.track(segs, "bw")
    bwmid<-dcut(bw, mustart(midvowel))
    rms<-emu.track(segs, "rms")
    rmsmid<-dcut(rms, mustart(midvowel))
    f0<-emu.track(segs, "F0")
    f0mid<-dcut(f0, mustart(midvowel))
    labvok<-koms

    mat <- NULL
    mat$lab<-koms
    mat$vowel<-labvok
    mat$f1<-formmid[,1]
    mat$f2<-formmid[,2]
    mat$f3<-formmid[,3]
    mat$bw1<-bwmid[,1]
    mat$bw2<-bwmid[,2]
    mat$bw3<-bwmid[,3]
    mat$rms<-rmsmid
    mat$f0<-f0mid
    mat$vdur<-mudur(segs)
    mat$utt<-utt(segs)
    voks=data.frame(mat)
